/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.libs.google.inject.internal;

import com.google.common.collect.Lists;
import java.util.List;
import net.shieldcommunity.nullcordx.libs.google.inject.Key;
import net.shieldcommunity.nullcordx.libs.google.inject.MembersInjector;
import net.shieldcommunity.nullcordx.libs.google.inject.Provider;
import net.shieldcommunity.nullcordx.libs.google.inject.TypeLiteral;
import net.shieldcommunity.nullcordx.libs.google.inject.internal.Errors;
import net.shieldcommunity.nullcordx.libs.google.inject.internal.InjectorImpl;
import net.shieldcommunity.nullcordx.libs.google.inject.internal.LookupProcessor;
import net.shieldcommunity.nullcordx.libs.google.inject.internal.Lookups;
import net.shieldcommunity.nullcordx.libs.google.inject.spi.Element;
import net.shieldcommunity.nullcordx.libs.google.inject.spi.MembersInjectorLookup;
import net.shieldcommunity.nullcordx.libs.google.inject.spi.ProviderLookup;

final class DeferredLookups
implements Lookups {
    private final InjectorImpl injector;
    private final List<Element> lookups = Lists.newArrayList();

    DeferredLookups(InjectorImpl injector) {
        this.injector = injector;
    }

    void initialize(Errors errors) {
        this.injector.lookups = this.injector;
        new LookupProcessor(errors).process(this.injector, this.lookups);
    }

    @Override
    public <T> Provider<T> getProvider(Key<T> key) {
        ProviderLookup<T> lookup = new ProviderLookup<T>(key, key);
        this.lookups.add(lookup);
        return lookup.getProvider();
    }

    @Override
    public <T> MembersInjector<T> getMembersInjector(TypeLiteral<T> type) {
        MembersInjectorLookup<T> lookup = new MembersInjectorLookup<T>(type, type);
        this.lookups.add(lookup);
        return lookup.getMembersInjector();
    }
}

