/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.libs.postgresql.ds.common;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import net.shieldcommunity.nullcordx.libs.checkerframework.checker.nullness.qual.Nullable;
import net.shieldcommunity.nullcordx.libs.postgresql.ds.PGConnectionPoolDataSource;
import net.shieldcommunity.nullcordx.libs.postgresql.ds.PGPoolingDataSource;
import net.shieldcommunity.nullcordx.libs.postgresql.ds.PGSimpleDataSource;
import net.shieldcommunity.nullcordx.libs.postgresql.ds.common.BaseDataSource;
import net.shieldcommunity.nullcordx.libs.postgresql.util.internal.Nullness;

public class PGObjectFactory
implements ObjectFactory {
    @Override
    public @Nullable Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Reference ref = (Reference)obj;
        String className = ref.getClassName();
        if ("net.shieldcommunity.nullcordx.libs.postgresql.ds.PGSimpleDataSource".equals(className) || "net.shieldcommunity.nullcordx.libs.postgresql.jdbc2.optional.SimpleDataSource".equals(className) || "net.shieldcommunity.nullcordx.libs.postgresql.jdbc3.Jdbc3SimpleDataSource".equals(className)) {
            return this.loadSimpleDataSource(ref);
        }
        if ("net.shieldcommunity.nullcordx.libs.postgresql.ds.PGConnectionPoolDataSource".equals(className) || "net.shieldcommunity.nullcordx.libs.postgresql.jdbc2.optional.ConnectionPool".equals(className) || "net.shieldcommunity.nullcordx.libs.postgresql.jdbc3.Jdbc3ConnectionPool".equals(className)) {
            return this.loadConnectionPool(ref);
        }
        if ("net.shieldcommunity.nullcordx.libs.postgresql.ds.PGPoolingDataSource".equals(className) || "net.shieldcommunity.nullcordx.libs.postgresql.jdbc2.optional.PoolingDataSource".equals(className) || "net.shieldcommunity.nullcordx.libs.postgresql.jdbc3.Jdbc3PoolingDataSource".equals(className)) {
            return this.loadPoolingDataSource(ref);
        }
        return null;
    }

    private Object loadPoolingDataSource(Reference ref) {
        String max;
        String name = Nullness.castNonNull(this.getProperty(ref, "dataSourceName"));
        PGPoolingDataSource pds = PGPoolingDataSource.getDataSource(name);
        if (pds != null) {
            return pds;
        }
        pds = new PGPoolingDataSource();
        pds.setDataSourceName(name);
        this.loadBaseDataSource(pds, ref);
        String min2 = this.getProperty(ref, "initialConnections");
        if (min2 != null) {
            pds.setInitialConnections(Integer.parseInt(min2));
        }
        if ((max = this.getProperty(ref, "maxConnections")) != null) {
            pds.setMaxConnections(Integer.parseInt(max));
        }
        return pds;
    }

    private Object loadSimpleDataSource(Reference ref) {
        PGSimpleDataSource ds = new PGSimpleDataSource();
        return this.loadBaseDataSource(ds, ref);
    }

    private Object loadConnectionPool(Reference ref) {
        PGConnectionPoolDataSource cp = new PGConnectionPoolDataSource();
        return this.loadBaseDataSource(cp, ref);
    }

    protected Object loadBaseDataSource(BaseDataSource ds, Reference ref) {
        ds.setFromReference(ref);
        return ds;
    }

    protected @Nullable String getProperty(Reference ref, String s2) {
        RefAddr addr = ref.get(s2);
        if (addr == null) {
            return null;
        }
        return (String)addr.getContent();
    }
}

