/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.libs.postgresql.replication.fluent;

import java.sql.SQLException;
import net.shieldcommunity.nullcordx.libs.postgresql.core.BaseConnection;
import net.shieldcommunity.nullcordx.libs.postgresql.core.ReplicationProtocol;
import net.shieldcommunity.nullcordx.libs.postgresql.replication.PGReplicationStream;
import net.shieldcommunity.nullcordx.libs.postgresql.replication.fluent.ChainedStreamBuilder;
import net.shieldcommunity.nullcordx.libs.postgresql.replication.fluent.logical.ChainedLogicalStreamBuilder;
import net.shieldcommunity.nullcordx.libs.postgresql.replication.fluent.logical.LogicalReplicationOptions;
import net.shieldcommunity.nullcordx.libs.postgresql.replication.fluent.logical.LogicalStreamBuilder;
import net.shieldcommunity.nullcordx.libs.postgresql.replication.fluent.logical.StartLogicalReplicationCallback;
import net.shieldcommunity.nullcordx.libs.postgresql.replication.fluent.physical.ChainedPhysicalStreamBuilder;
import net.shieldcommunity.nullcordx.libs.postgresql.replication.fluent.physical.PhysicalReplicationOptions;
import net.shieldcommunity.nullcordx.libs.postgresql.replication.fluent.physical.PhysicalStreamBuilder;
import net.shieldcommunity.nullcordx.libs.postgresql.replication.fluent.physical.StartPhysicalReplicationCallback;

public class ReplicationStreamBuilder
implements ChainedStreamBuilder {
    private final BaseConnection baseConnection;

    public ReplicationStreamBuilder(BaseConnection connection) {
        this.baseConnection = connection;
    }

    @Override
    public ChainedLogicalStreamBuilder logical() {
        return new LogicalStreamBuilder(new StartLogicalReplicationCallback(){

            @Override
            public PGReplicationStream start(LogicalReplicationOptions options) throws SQLException {
                ReplicationProtocol protocol = ReplicationStreamBuilder.this.baseConnection.getReplicationProtocol();
                return protocol.startLogical(options);
            }
        });
    }

    @Override
    public ChainedPhysicalStreamBuilder physical() {
        return new PhysicalStreamBuilder(new StartPhysicalReplicationCallback(){

            @Override
            public PGReplicationStream start(PhysicalReplicationOptions options) throws SQLException {
                ReplicationProtocol protocol = ReplicationStreamBuilder.this.baseConnection.getReplicationProtocol();
                return protocol.startPhysical(options);
            }
        });
    }
}

