/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.libs.unimi.dsi.big.util;

import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import java.io.IOException;
import java.io.Serializable;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.Util;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.big.util.FrontCodedStringBigList;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.BigArrays;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.io.BinIO;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.io.TextIO;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.longs.LongIterators;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.objects.AbstractObjectBigList;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.objects.ObjectBigListIterator;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.lang.MutableString;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.util.PermutedFrontCodedStringList;

public class PermutedFrontCodedStringBigList
extends AbstractObjectBigList<CharSequence>
implements Serializable {
    public static final long serialVersionUID = 1L;
    protected final FrontCodedStringBigList frontCodedStringBigList;
    protected final long[][] permutation;

    public PermutedFrontCodedStringBigList(FrontCodedStringBigList frontCodedStringBihList, long[][] permutation) {
        if (frontCodedStringBihList.size64() != BigArrays.length(permutation)) {
            throw new IllegalArgumentException("The front-coded string big list contains " + frontCodedStringBihList.size64() + " strings, but the permutation is on " + BigArrays.length(permutation) + " elements.");
        }
        this.frontCodedStringBigList = frontCodedStringBihList;
        this.permutation = permutation;
    }

    public MutableString get(long index) {
        return this.frontCodedStringBigList.get(BigArrays.get(this.permutation, index));
    }

    public void get(long index, MutableString s2) {
        this.frontCodedStringBigList.get(BigArrays.get(this.permutation, index), s2);
    }

    public long size64() {
        return this.frontCodedStringBigList.size64();
    }

    public ObjectBigListIterator<CharSequence> listIterator(long k) {
        return new ObjectBigListIterator<CharSequence>(){
            final LongBidirectionalIterator i;
            long p;
            {
                this.i = LongIterators.fromTo(0L, PermutedFrontCodedStringBigList.this.frontCodedStringBigList.size64());
                this.p = 0L;
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public boolean hasPrevious() {
                return this.i.hasPrevious();
            }

            public CharSequence next() {
                ++this.p;
                return PermutedFrontCodedStringBigList.this.frontCodedStringBigList.get(BigArrays.get(PermutedFrontCodedStringBigList.this.permutation, this.i.nextLong()));
            }

            public CharSequence previous() {
                --this.p;
                return PermutedFrontCodedStringBigList.this.frontCodedStringBigList.get(BigArrays.get(PermutedFrontCodedStringBigList.this.permutation, this.i.previousLong()));
            }

            public long nextIndex() {
                return this.p;
            }

            public long previousIndex() {
                return this.p - 1L;
            }
        };
    }

    public static void main(String[] arg) throws IOException, ClassNotFoundException, JSAPException {
        long[][] permutation;
        SimpleJSAP jsap = new SimpleJSAP(PermutedFrontCodedStringList.class.getName(), "Builds a permuted front-coded list of strings using a given front-coded string list and a permutation (either in text or binary format).", new Parameter[]{new Switch("invert", 'i', "invert", "Invert permutation before creating the permuted list."), new Switch("text", 't', "text", "The permutation is a text file."), new UnflaggedOption("list", JSAP.STRING_PARSER, true, "A front-coded string big list."), new UnflaggedOption("permutation", JSAP.STRING_PARSER, true, "A permutation for the indices of the list (longs in DataInput format, unless you specify --text)."), new UnflaggedOption("permutedList", JSAP.STRING_PARSER, true, "A the filename for the resulting permuted big list.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        String permutationFile = jsapResult.getString("permutation");
        long[][] lArray = permutation = jsapResult.userSpecified("text") ? LongIterators.unwrapBig(TextIO.asLongIterator((CharSequence)permutationFile)) : BinIO.loadLongsBig((CharSequence)permutationFile);
        if (jsapResult.getBoolean("invert")) {
            Util.invertPermutationInPlace(permutation);
        }
        BinIO.storeObject((Object)new PermutedFrontCodedStringBigList((FrontCodedStringBigList)BinIO.loadObject((CharSequence)jsapResult.getString("list")), permutation), (CharSequence)jsapResult.getString("permutedList"));
    }
}

