/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.libs.unimi.dsi.big.util;

import java.io.EOFException;
import java.io.IOException;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.longs.AbstractLongBigList;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.io.InputBitStream;

public class SemiExternalGammaBigList
extends AbstractLongBigList {
    public static final int DEFAULT_STEP = 128;
    private final long[] position;
    private final InputBitStream ibs;
    private final int step;
    private final long numLongs;

    public SemiExternalGammaBigList(InputBitStream longs, int step, long numLongs) throws IOException {
        this.step = Math.max(step == -1 ? 128 : step, (int)(numLongs / 0x80000000L));
        int slots = (int)((numLongs + (long)this.step - 1L) / (long)this.step);
        this.position = new long[slots];
        this.numLongs = numLongs;
        this.ibs = longs;
        this.ibs.position(0L);
        this.ibs.readBits(0L);
        int lastSlot = this.position.length - 1;
        for (int i = 0; i <= lastSlot; ++i) {
            this.position[i] = this.ibs.readBits();
            if (i == lastSlot) continue;
            this.ibs.skipGammas(this.step);
        }
    }

    public SemiExternalGammaBigList(InputBitStream longs) throws IOException {
        this(longs, 128, SemiExternalGammaBigList.estimateNumberOfLongs(longs));
    }

    private static int estimateNumberOfLongs(InputBitStream longs) {
        int numLongs = 0;
        try {
            longs.position(0L);
            while (true) {
                longs.readLongGamma();
                ++numLongs;
            }
        }
        catch (EOFException e) {
            return numLongs;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public final long getLong(long index) {
        if (index < 0L || index >= this.numLongs) {
            throw new IndexOutOfBoundsException(Long.toString(index));
        }
        int slotNumber = (int)(index / (long)this.step);
        int k = (int)(index % (long)this.step);
        try {
            this.ibs.position(this.position[slotNumber]);
            this.ibs.skipGammas(k);
            return this.ibs.readLongGamma();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public long size64() {
        return this.numLongs;
    }
}

