/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.libs.unimi.dsi.bits;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.bits.AbstractBitVector;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.bits.BitVector;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.bits.LongArrayBitVector;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.bits.TransformationStrategies;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.bits.TransformationStrategy;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.io.OfflineIterable;

public class BitVectors {
    public static final BitVector EMPTY_VECTOR = new AbstractBitVector(){

        @Override
        public final long length() {
            return 0L;
        }

        @Override
        public final BitVector copy(long from, long to) {
            BitVectors.ensureFromTo(0L, from, to);
            return EMPTY_VECTOR;
        }

        public final boolean getBoolean(long index) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public BitVector copy() {
            return this;
        }

        public Object readResolve() {
            return EMPTY_VECTOR;
        }
    };
    public static final BitVector ZERO = new AbstractBitVector(){

        @Override
        public final long length() {
            return 1L;
        }

        @Override
        public final BitVector copy(long from, long to) {
            BitVectors.ensureFromTo(1L, from, to);
            return from == to ? EMPTY_VECTOR : this;
        }

        public final boolean getBoolean(long index) {
            if (index > 0L) {
                throw new IndexOutOfBoundsException();
            }
            return false;
        }

        @Override
        public BitVector copy() {
            return this;
        }

        public Object readResolve() {
            return ZERO;
        }
    };
    public static final BitVector ONE = new AbstractBitVector(){

        @Override
        public final long length() {
            return 1L;
        }

        @Override
        public final BitVector copy(long from, long to) {
            BitVectors.ensureFromTo(1L, from, to);
            return from == to ? EMPTY_VECTOR : this;
        }

        public final boolean getBoolean(long index) {
            if (index > 0L) {
                throw new IndexOutOfBoundsException();
            }
            return true;
        }

        @Override
        public BitVector copy() {
            return this;
        }

        public Object readResolve() {
            return ONE;
        }
    };
    public static BitVectorOfflineSerializer OFFLINE_SERIALIZER = new BitVectorOfflineSerializer();

    private BitVectors() {
    }

    @Deprecated
    public static <T extends BitVector> TransformationStrategy<T> identity() {
        return TransformationStrategies.identity();
    }

    public static void ensureFromTo(long bitVectorLength, long from, long to) {
        if (from < 0L) {
            throw new ArrayIndexOutOfBoundsException("Start index (" + from + ") is negative");
        }
        if (from > to) {
            throw new IllegalArgumentException("Start index (" + from + ") is greater than end index (" + to + ")");
        }
        if (to > bitVectorLength) {
            throw new ArrayIndexOutOfBoundsException("End index (" + to + ") is greater than bit vector length (" + bitVectorLength + ")");
        }
    }

    public static void writeFast(BitVector v, DataOutput dos) throws IOException {
        long i;
        long length = v.length();
        long l = length & 0xFFFFFFFFFFFFFFC0L;
        dos.writeLong(length);
        for (i = 0L; i < l; i += 64L) {
            dos.writeLong(v.getLong(i, i + 64L));
        }
        if (i < length) {
            dos.writeLong(v.getLong(i, length));
        }
    }

    public static LongArrayBitVector readFast(DataInput dis) throws IOException {
        long length = dis.readLong();
        long[] bits = new long[LongArrayBitVector.words(length)];
        int l = bits.length;
        for (int i = 0; i < l; ++i) {
            bits[i] = dis.readLong();
        }
        return LongArrayBitVector.wrap(bits, length);
    }

    public static LongArrayBitVector readFast(DataInput dis, LongArrayBitVector bv) throws IOException {
        long length = dis.readLong();
        bv.ensureCapacity(length);
        int l = LongArrayBitVector.words(length);
        for (int i = 0; i < l; ++i) {
            bv.bits[i] = dis.readLong();
        }
        bv.length(length);
        return bv;
    }

    private static class BitVectorOfflineSerializer
    implements OfflineIterable.Serializer<BitVector, LongArrayBitVector> {
        private BitVectorOfflineSerializer() {
        }

        @Override
        public void write(BitVector bv, DataOutput dos) throws IOException {
            BitVectors.writeFast(bv, dos);
        }

        @Override
        public void read(DataInput dis, LongArrayBitVector bv) throws IOException {
            BitVectors.readFast(dis, bv);
        }
    }
}

