/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.libs.unimi.dsi.io;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Reader;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.chars.CharArrays;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.chars.CharOpenHashSet;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.chars.CharSet;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.chars.CharSets;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.io.NullReader;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.io.WordReader;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.lang.MutableString;

public class FastBufferedReader
extends Reader
implements WordReader {
    public static final long serialVersionUID = 1L;
    public static final int DEFAULT_BUFFER_SIZE = 16384;
    protected final int bufferSize;
    protected final CharSet wordConstituents;
    protected transient char[] buffer;
    protected transient int pos;
    protected transient int avail;
    protected transient Reader reader;

    public FastBufferedReader(int bufferSize) {
        this(bufferSize, (CharSet)CharSets.EMPTY_SET);
    }

    public FastBufferedReader(int bufferSize, CharSet wordConstituents) {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("The buffer size must be strictly positive.");
        }
        this.bufferSize = bufferSize;
        this.buffer = new char[this.bufferSize];
        this.wordConstituents = wordConstituents;
    }

    public FastBufferedReader() {
        this(16384);
    }

    public FastBufferedReader(CharSet wordConstituents) {
        this(16384, wordConstituents);
    }

    public FastBufferedReader(String wordConstituents) {
        this((CharSet)new CharOpenHashSet(wordConstituents.toCharArray(), 0.25f));
        if (wordConstituents.length() != this.wordConstituents.size()) {
            throw new IllegalArgumentException("Repeated characters in word constituents: \"" + wordConstituents + "\"");
        }
    }

    public FastBufferedReader(String bufferSize, String wordConstituents) {
        this(Integer.parseInt(bufferSize), (CharSet)new CharOpenHashSet(wordConstituents.toCharArray(), 0.25f));
    }

    public FastBufferedReader(Reader r, int bufferSize) {
        this(bufferSize);
        this.reader = r;
    }

    public FastBufferedReader(Reader r, int bufferSize, CharSet wordConstituents) {
        this(bufferSize, wordConstituents);
        this.reader = r;
    }

    public FastBufferedReader(Reader r) {
        this(r, 16384);
    }

    public FastBufferedReader(Reader r, CharSet wordConstituents) {
        this(r, 16384, wordConstituents);
    }

    public FastBufferedReader(char[] array, int offset, int length, CharSet wordConstituents) {
        CharArrays.ensureOffsetLength((char[])array, (int)offset, (int)length);
        this.buffer = array;
        this.pos = offset;
        this.avail = length;
        this.bufferSize = array.length;
        this.reader = NullReader.getInstance();
        this.wordConstituents = wordConstituents;
    }

    public FastBufferedReader(char[] array, int offset, int length) {
        this(array, offset, length, (CharSet)CharSets.EMPTY_SET);
    }

    public FastBufferedReader(char[] array, CharSet wordConstituents) {
        this(array, 0, array.length, wordConstituents);
    }

    public FastBufferedReader(char[] array) {
        this(array, 0, array.length);
    }

    public FastBufferedReader(MutableString s2, CharSet wordConstituents) {
        this(s2.array(), 0, s2.length(), wordConstituents);
    }

    public FastBufferedReader(MutableString s2) {
        this(s2.array(), 0, s2.length());
    }

    @Override
    public FastBufferedReader copy() {
        return new FastBufferedReader(this.bufferSize, this.wordConstituents);
    }

    protected boolean noMoreCharacters() throws IOException {
        if (this.avail == 0) {
            this.avail = this.reader.read(this.buffer);
            if (this.avail <= 0) {
                this.avail = 0;
                return true;
            }
            this.pos = 0;
        }
        return false;
    }

    @Override
    public int read() throws IOException {
        if (this.noMoreCharacters()) {
            return -1;
        }
        --this.avail;
        return this.buffer[this.pos++];
    }

    @Override
    public int read(char[] b, int offset, int length) throws IOException {
        CharArrays.ensureOffsetLength((char[])b, (int)offset, (int)length);
        if (length <= this.avail) {
            System.arraycopy(this.buffer, this.pos, b, offset, length);
            this.pos += length;
            this.avail -= length;
            return length;
        }
        int head = this.avail;
        System.arraycopy(this.buffer, this.pos, b, offset, head);
        this.avail = 0;
        int result = this.reader.read(b, offset += head, length -= head);
        return result < 0 ? (head != 0 ? head : -1) : result + head;
    }

    public MutableString readLine(MutableString s2) throws IOException {
        char c = '\u0000';
        if (this.noMoreCharacters()) {
            return null;
        }
        s2.length(0);
        do {
            int i;
            for (i = 0; i < this.avail && (c = this.buffer[this.pos + i]) != '\n' && c != '\r'; ++i) {
            }
            s2.append(this.buffer, this.pos, i);
            this.pos += i;
            this.avail -= i;
            if (this.avail <= 0) continue;
            if (c == '\n') {
                ++this.pos;
                --this.avail;
            } else {
                ++this.pos;
                --this.avail;
                if (this.avail > 0) {
                    if (this.buffer[this.pos] == '\n') {
                        ++this.pos;
                        --this.avail;
                    }
                } else {
                    if (this.noMoreCharacters()) {
                        return s2;
                    }
                    if (this.buffer[0] == '\n') {
                        ++this.pos;
                        --this.avail;
                    }
                }
            }
            return s2;
        } while (!this.noMoreCharacters());
        return s2;
    }

    protected boolean isWordConstituent(char c) {
        return Character.isLetterOrDigit(c) || this.wordConstituents.contains(c);
    }

    @Override
    public boolean next(MutableString word, MutableString nonWord) throws IOException {
        int i;
        char[] buffer = this.buffer;
        if (this.noMoreCharacters()) {
            return false;
        }
        word.length(0);
        nonWord.length(0);
        do {
            for (i = 0; i < this.avail && this.isWordConstituent(buffer[this.pos + i]); ++i) {
            }
            word.append(buffer, this.pos, i);
            this.pos += i;
            this.avail -= i;
        } while (this.avail <= 0 && !this.noMoreCharacters());
        if (this.noMoreCharacters()) {
            return true;
        }
        do {
            for (i = 0; i < this.avail && !this.isWordConstituent(buffer[this.pos + i]); ++i) {
            }
            nonWord.append(buffer, this.pos, i);
            this.pos += i;
            this.avail -= i;
        } while (this.avail <= 0 && !this.noMoreCharacters());
        return true;
    }

    @Override
    public FastBufferedReader setReader(Reader reader) {
        this.reader = reader;
        this.avail = 0;
        return this;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= (long)this.avail) {
            this.pos += (int)n;
            this.avail -= (int)n;
            return n;
        }
        int head = this.avail;
        this.avail = 0;
        return this.reader.skip(n -= (long)head) + (long)head;
    }

    @Override
    public void close() throws IOException {
        if (this.reader == null) {
            return;
        }
        this.reader.close();
        this.reader = null;
        this.buffer = null;
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.buffer = new char[this.bufferSize];
    }

    public String toSpec() {
        return this.toString();
    }

    public String toString() {
        String className = this.getClass().getName();
        if (this.bufferSize == 16384 && this.wordConstituents.isEmpty()) {
            return className;
        }
        if (this.wordConstituents.isEmpty()) {
            return className + "(" + this.bufferSize + ")";
        }
        String wordConstituents = new String(this.wordConstituents.toCharArray());
        if (this.bufferSize == 16384) {
            return className + "(\"" + wordConstituents + "\")";
        }
        return className + "(" + this.bufferSize + ",\"" + wordConstituents + "\")";
    }
}

