/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.libs.unimi.dsi.stat;

import net.shieldcommunity.nullcordx.libs.unimi.dsi.Util;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.Size64;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.doubles.DoubleList;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.doubles.DoubleListIterator;

public class SummaryStats
implements Size64 {
    private double a;
    private double q;
    private double min = Double.POSITIVE_INFINITY;
    private double max = Double.NEGATIVE_INFINITY;
    private long size;

    public synchronized void add(double x) {
        double oldA = this.a;
        this.a += (x - this.a) / (double)(++this.size);
        this.q += (x - this.a) * (x - oldA);
        if (x < this.min) {
            this.min = x;
        }
        if (x > this.max) {
            this.max = x;
        }
    }

    public void addAll(double[] a) {
        for (double x : a) {
            this.add(x);
        }
    }

    public void addAll(DoubleList l) {
        DoubleListIterator doubleListIterator = l.iterator();
        while (doubleListIterator.hasNext()) {
            double x = (Double)doubleListIterator.next();
            this.add(x);
        }
    }

    public synchronized double mean() {
        return this.a;
    }

    public synchronized double sum() {
        return this.a * (double)this.size;
    }

    public synchronized double sampleVariance() {
        return this.q / (double)(this.size - 1L);
    }

    public synchronized double variance() {
        return this.q / (double)this.size;
    }

    public synchronized double sampleStandardDeviation() {
        return Math.sqrt(this.sampleVariance());
    }

    public synchronized double standardDeviation() {
        return Math.sqrt(this.variance());
    }

    public synchronized double sampleRelativeStandardDeviation() {
        return Math.sqrt(this.sampleVariance()) / this.mean();
    }

    public synchronized double relativeStandardDeviation() {
        return Math.sqrt(this.variance()) / this.mean();
    }

    public synchronized double min() {
        return this.min;
    }

    public synchronized double max() {
        return this.max;
    }

    @Override
    public synchronized long size64() {
        return this.size;
    }

    @Override
    @Deprecated
    public int size() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "[size: " + Util.format(this.size64()) + " min: " + this.min + " max: " + this.max + " \u03bc: " + this.mean() + " \u03c3: " + this.sampleStandardDeviation() + " (" + Util.format(100.0 * this.sampleRelativeStandardDeviation()) + " %)]";
    }
}

