/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.modules.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.TabExecutor;
import net.shieldcommunity.nullcordx.chat.modern.ReadyComponentMessage;
import net.shieldcommunity.nullcordx.libs.kyori.adventure.text.Component;
import net.shieldcommunity.nullcordx.libs.kyori.adventure.text.event.ClickEvent;
import net.shieldcommunity.nullcordx.libs.kyori.adventure.text.event.HoverEvent;

public class CommandList
extends Command
implements TabExecutor {
    public CommandList() {
        super("glist", "bungeecord.command.list", new String[0]);
    }

    @Override
    public void execute(CommandSender sender, String[] args) {
        boolean hideEmptyServers = args.length == 0 || !args[0].equalsIgnoreCase("all");
        boolean moduleLoaded = ProxyServer.getInstance().getNullCordX().getRegisteredModule("module-send") != null;
        for (ServerInfo server : ProxyServer.getInstance().getServersCopy().values()) {
            if (!server.canAccess(sender)) continue;
            Collection<ProxiedPlayer> serverPlayers = server.getPlayers();
            if (hideEmptyServers && serverPlayers.isEmpty()) continue;
            ArrayList<String> players = new ArrayList<String>();
            for (ProxiedPlayer player : serverPlayers) {
                players.add(player.getDisplayName());
            }
            players.sort(String.CASE_INSENSITIVE_ORDER);
            ReadyComponentMessage readyComponentMessage = ProxyServer.getInstance().getTranslationComponent("command_list", sender.getLanguageType()).replace("server", server.getName()).replace("count", "" + players.size()).replace("players", Component.text(String.join((CharSequence)", ", players)));
            if (moduleLoaded) {
                Component component = readyComponentMessage.getComponent().hoverEvent(HoverEvent.hoverEvent(HoverEvent.Action.SHOW_TEXT, ProxyServer.getInstance().getTranslationComponent("click_to_connect", sender.getLanguageType()).getComponent())).clickEvent(ClickEvent.clickEvent(ClickEvent.Action.RUN_COMMAND, "/server " + server.getName()));
                readyComponentMessage = new ReadyComponentMessage(component);
            }
            sender.sendMessage((BaseComponent)readyComponentMessage);
        }
        sender.sendMessage((BaseComponent)ProxyServer.getInstance().getTranslationComponent("total_players", sender.getLanguageType()).replace("count", "" + ProxyServer.getInstance().getOnlineCount()));
    }

    @Override
    public Iterable<String> onTabComplete(CommandSender sender, String[] args) {
        return args.length > 1 ? Collections.emptyList() : Collections.singletonList("all");
    }
}

