/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.modules.reconnect;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import net.md_5.bungee.api.AbstractReconnectHandler;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.JsonConfiguration;

public class JsonReconnectHandler
extends AbstractReconnectHandler {
    private Configuration configuration;
    private final File file = new File("locations.json");
    private final ConfigurationProvider provider = ConfigurationProvider.getProvider(JsonConfiguration.class);
    private final Map<UUID, String> data;
    private boolean closed = false;

    public JsonReconnectHandler() {
        if (!this.file.exists()) {
            try {
                this.file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            this.configuration = this.provider.load(this.file);
        }
        catch (IOException e) {
            this.file.renameTo(new File("locations.json.old"));
            ProxyServer.getInstance().getLogger().log(Level.WARNING, "Could not load reconnect locations, resetting them");
        }
        this.data = new ConcurrentHashMap<UUID, String>();
        for (String key : this.configuration.getKeys()) {
            String server = this.configuration.getString(key);
            this.data.put(UUID.fromString(key), server);
        }
    }

    @Override
    protected ServerInfo getStoredServer(ProxiedPlayer player) {
        return ProxyServer.getInstance().getServerInfo(this.data.get(player.getUniqueId()));
    }

    @Override
    public void setServer(ProxiedPlayer player) {
        String server;
        if (this.closed) {
            return;
        }
        String string = server = player.getReconnectServer() != null ? player.getReconnectServer().getName() : player.getServer().getInfo().getName();
        if (!this.data.containsKey(player.getUniqueId())) {
            this.data.put(player.getUniqueId(), server);
        } else {
            this.data.replace(player.getUniqueId(), server);
        }
    }

    @Override
    public void save() {
        if (this.closed) {
            return;
        }
        for (Map.Entry<UUID, String> entry : this.data.entrySet()) {
            this.configuration.set(entry.getKey().toString(), entry.getValue());
        }
        try {
            this.provider.save(this.configuration, this.file);
        }
        catch (IOException e) {
            ProxyServer.getInstance().getLogger().log(Level.WARNING, "Could not save reconnect locations", e);
        }
    }

    @Override
    public void close() {
        this.closed = true;
    }
}

