/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.modules.server;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.ServerConnectEvent;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.TabExecutor;
import net.shieldcommunity.nullcordx.chat.modern.ReadyComponentMessage;
import net.shieldcommunity.nullcordx.libs.kyori.adventure.text.Component;
import net.shieldcommunity.nullcordx.libs.kyori.adventure.text.TextComponent;
import net.shieldcommunity.nullcordx.libs.kyori.adventure.text.event.ClickEvent;
import net.shieldcommunity.nullcordx.libs.kyori.adventure.text.event.HoverEvent;

public class CommandServer
extends Command
implements TabExecutor {
    public CommandServer() {
        super("server", "bungeecord.command.server", new String[0]);
    }

    @Override
    public void execute(CommandSender sender, String[] args) {
        Map<String, ServerInfo> servers = ProxyServer.getInstance().getServersCopy();
        if (args.length == 0) {
            if (sender instanceof ProxiedPlayer) {
                ProxiedPlayer player = (ProxiedPlayer)sender;
                sender.sendMessage((BaseComponent)ProxyServer.getInstance().getTranslationComponent("current_server", sender.getLanguageType()).replace("server", player.getServer().getInfo().getName()));
            }
            ReadyComponentMessage readyComponentMessage = ProxyServer.getInstance().getTranslationComponent("server_list", sender.getLanguageType());
            Component serverList = readyComponentMessage.getComponent();
            boolean first = true;
            for (ServerInfo server : servers.values()) {
                if (!server.canAccess(sender)) continue;
                int count = server.getPlayers().size();
                Component serverTextComponent = ((TextComponent)Component.text((String)(first ? server.getName() : ", " + server.getName())).hoverEvent(HoverEvent.hoverEvent(HoverEvent.Action.SHOW_TEXT, Component.text(count + (count == 1 ? " player" : " players") + "\n").append(ProxyServer.getInstance().getTranslationComponent("click_to_connect", sender.getLanguageType()).getComponent())))).clickEvent(ClickEvent.clickEvent(ClickEvent.Action.RUN_COMMAND, "/server " + server.getName()));
                serverList = serverList.append(serverTextComponent);
                first = false;
            }
            sender.sendMessage((BaseComponent)new ReadyComponentMessage(serverList));
            return;
        }
        if (!(sender instanceof ProxiedPlayer)) {
            return;
        }
        ProxiedPlayer player = (ProxiedPlayer)sender;
        ServerInfo server = servers.get(args[0]);
        if (server == null) {
            player.sendMessage((BaseComponent)ProxyServer.getInstance().getTranslationComponent("no_server", sender.getLanguageType()));
        } else if (!server.canAccess(player)) {
            player.sendMessage((BaseComponent)ProxyServer.getInstance().getTranslationComponent("no_server_permission", sender.getLanguageType()));
        } else {
            player.connect(server, ServerConnectEvent.Reason.COMMAND);
        }
    }

    @Override
    public Iterable<String> onTabComplete(CommandSender sender, String[] args) {
        if (args.length != 1) {
            return Collections.emptyList();
        }
        String lower = args[0].toLowerCase(Locale.ROOT);
        return ProxyServer.getInstance().getServersCopy().values().stream().filter(info -> info.getName().toLowerCase(Locale.ROOT).startsWith(lower) && info.canAccess(sender)).map(info -> info.getName().toLowerCase()).collect(Collectors.toList());
    }
}

