/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.natives.compression.igzip;

import net.shieldcommunity.nullcordx.natives.compression.Compressor;
import net.shieldcommunity.nullcordx.natives.compression.CompressorFactory;
import net.shieldcommunity.nullcordx.natives.compression.Decompressor;
import net.shieldcommunity.nullcordx.natives.compression.igzip.IgzipCompressor;
import net.shieldcommunity.nullcordx.natives.compression.igzip.IgzipDecompressor;

public class IgzipCompressorFactory
implements CompressorFactory {
    private final String name;
    private final String nativePath;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNativePath() {
        return this.nativePath;
    }

    @Override
    public Compressor createCompressor(int level) {
        return new IgzipCompressor(level);
    }

    @Override
    public Decompressor createDecompressor() {
        return new IgzipDecompressor();
    }

    public IgzipCompressorFactory(String name, String nativePath) {
        this.name = name;
        this.nativePath = nativePath;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IgzipCompressorFactory)) {
            return false;
        }
        IgzipCompressorFactory other = (IgzipCompressorFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$nativePath = this.getNativePath();
        String other$nativePath = other.getNativePath();
        return !(this$nativePath == null ? other$nativePath != null : !this$nativePath.equals(other$nativePath));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IgzipCompressorFactory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $nativePath = this.getNativePath();
        result = result * 59 + ($nativePath == null ? 43 : $nativePath.hashCode());
        return result;
    }

    public String toString() {
        return "IgzipCompressorFactory(name=" + this.getName() + ", nativePath=" + this.getNativePath() + ")";
    }
}

