/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.natives.compression.java;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import net.shieldcommunity.nullcordx.natives.ByteBufAllocationUtils;
import net.shieldcommunity.nullcordx.natives.compression.Decompressor;

public class JavaDecompressor
implements Decompressor {
    private final Inflater inflater = new Inflater();
    private boolean closed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inflate(ByteBuf source, ByteBuf destination, int uncompressedSize) throws DataFormatException {
        Preconditions.checkState(!this.closed, "Decompressor already closed");
        Preconditions.checkArgument(source.nioBufferCount() == 1, "source has multiple backing buffers");
        Preconditions.checkArgument(destination.nioBufferCount() == 1, "destination has multiple backing buffers");
        try {
            byte[] inData = new byte[source.readableBytes()];
            source.readBytes(inData);
            this.inflater.setInput(inData);
            byte[] buffer = ByteBufAllocationUtils.ZLIB_DEFAULT_BUFFER.get();
            while (!this.inflater.finished() && this.inflater.getTotalIn() < inData.length) {
                int count = this.inflater.inflate(buffer);
                destination.writeBytes(buffer, 0, count);
            }
        }
        finally {
            this.inflater.reset();
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.inflater.end();
        }
        this.closed = true;
    }

    @Override
    public boolean isNeedDirectBuffer() {
        return false;
    }
}

