/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.natives.compression.zlib;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.util.zip.DataFormatException;
import net.md_5.bungee.jni.zlib.NativeCompressImpl;
import net.shieldcommunity.nullcordx.natives.compression.Decompressor;

public class ZlibDecompressor
implements Decompressor {
    private final NativeCompressImpl nativeCompress = new NativeCompressImpl();
    private final long ctx;
    private boolean closed = false;

    public ZlibDecompressor() {
        this.free();
        this.ctx = this.nativeCompress.init(false, 6);
    }

    @Override
    public void inflate(ByteBuf source, ByteBuf destination, int uncompressedSize) throws DataFormatException {
        Preconditions.checkState(!this.closed, "Decompressor already closed");
        source.memoryAddress();
        destination.memoryAddress();
        Preconditions.checkState(this.ctx != 0L, "Invalid pointer to decompressor!");
        while (!this.nativeCompress.finished && source.isReadable()) {
            destination.ensureWritable(8192);
            int processed = this.nativeCompress.process(this.ctx, source.memoryAddress() + (long)source.readerIndex(), source.readableBytes(), destination.memoryAddress() + (long)destination.writerIndex(), destination.writableBytes(), false);
            source.readerIndex(source.readerIndex() + this.nativeCompress.consumed);
            destination.writerIndex(destination.writerIndex() + processed);
        }
        this.nativeCompress.reset(this.ctx, false);
        this.nativeCompress.consumed = 0;
        this.nativeCompress.finished = false;
    }

    private void free() {
        if (this.ctx != 0L) {
            this.nativeCompress.end(this.ctx, false);
        }
        this.nativeCompress.consumed = 0;
        this.nativeCompress.finished = false;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.free();
        }
        this.closed = true;
    }

    @Override
    public boolean isNeedDirectBuffer() {
        return true;
    }
}

