/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.protocol;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import se.llbit.nbt.ByteTag;
import se.llbit.nbt.CompoundTag;
import se.llbit.nbt.DoubleTag;
import se.llbit.nbt.FloatTag;
import se.llbit.nbt.IntTag;
import se.llbit.nbt.ListTag;
import se.llbit.nbt.LongTag;
import se.llbit.nbt.NamedTag;
import se.llbit.nbt.SpecificTag;
import se.llbit.nbt.StringTag;
import se.llbit.nbt.Tag;

public final class ProtocolDimensionType
extends Enum<ProtocolDimensionType> {
    public static final /* enum */ ProtocolDimensionType OVERWORLD;
    public static final /* enum */ ProtocolDimensionType THE_NETHER;
    public static final /* enum */ ProtocolDimensionType THE_END;
    private final String key;
    private final int dimensionId;
    private final int id;
    private final boolean piglinSafe;
    private final boolean natural;
    private final float ambientLight;
    private final String infiniburn;
    private final boolean respawnAnchorWorks;
    private final boolean hasSkylight;
    private final boolean bedWorks;
    private final String effects;
    private final boolean hasRaids;
    private final int monster_spawn_light_level;
    private final int monster_spawn_block_light_limit;
    private final int logicalHeight;
    private final float coordinateScale;
    private final boolean ultrawarm;
    private final boolean hasCeiling;
    private final int minY;
    private final int height;
    private static final CompoundTag DAMAGE_TYPE_TAG_1_19_4;
    private static final CompoundTag DAMAGE_TYPE_TAG_1_20;
    private static final /* synthetic */ ProtocolDimensionType[] $VALUES;

    public static ProtocolDimensionType[] values() {
        return (ProtocolDimensionType[])$VALUES.clone();
    }

    public static ProtocolDimensionType valueOf(String name) {
        return Enum.valueOf(ProtocolDimensionType.class, name);
    }

    public Tag getFullCodec(int protocolVersion) {
        CompoundTag attributes = this.encodeAttributes(protocolVersion);
        if (protocolVersion <= 736) {
            CompoundTag dimensions = new CompoundTag();
            dimensions.add("dimension", new ListTag(10, Collections.singletonList(attributes)));
            return new NamedTag("", dimensions);
        }
        CompoundTag dimensionData = new CompoundTag();
        dimensionData.add("name", new StringTag(this.key));
        dimensionData.add("id", new IntTag(this.id));
        dimensionData.add("element", attributes);
        CompoundTag dimensions = new CompoundTag();
        dimensions.add("type", new StringTag("minecraft:dimension_type"));
        dimensions.add("value", new ListTag(10, Collections.singletonList(dimensionData)));
        CompoundTag root = new CompoundTag();
        root.add("minecraft:dimension_type", dimensions);
        root.add("minecraft:worldgen/biome", this.createBiomeRegistry(protocolVersion));
        if (protocolVersion >= 762) {
            if (protocolVersion >= 763) {
                root.add("minecraft:damage_type", DAMAGE_TYPE_TAG_1_20);
            } else {
                root.add("minecraft:damage_type", DAMAGE_TYPE_TAG_1_19_4);
            }
        }
        if (protocolVersion >= 759) {
            root.add("minecraft:chat_type", this.createChatRegistry(protocolVersion));
        }
        if (protocolVersion >= 764) {
            return root;
        }
        return new NamedTag("", root);
    }

    public Tag getAttributes(int protocolVersion) {
        return new NamedTag("", this.encodeAttributes(protocolVersion));
    }

    private CompoundTag encodeAttributes(int protocolVersion) {
        HashMap<String, SpecificTag> attributes = new HashMap<String, SpecificTag>();
        attributes.put("name", new StringTag(this.key));
        attributes.put("natural", new ByteTag(this.natural ? 1 : 0));
        attributes.put("has_skylight", new ByteTag(this.hasSkylight ? 1 : 0));
        attributes.put("has_ceiling", new ByteTag(this.hasCeiling ? 1 : 0));
        attributes.put("fixed_time", new LongTag(10000L));
        attributes.put("shrunk", new ByteTag(0));
        attributes.put("ambient_light", new FloatTag(this.ambientLight));
        attributes.put("ultrawarm", new ByteTag(this.ultrawarm ? 1 : 0));
        attributes.put("has_raids", new ByteTag(this.hasRaids ? 1 : 0));
        attributes.put("respawn_anchor_works", new ByteTag(this.respawnAnchorWorks ? 1 : 0));
        attributes.put("bed_works", new ByteTag(this.bedWorks ? 1 : 0));
        attributes.put("piglin_safe", new ByteTag(this.piglinSafe ? 1 : 0));
        attributes.put("infiniburn", new StringTag(this.infiniburn));
        attributes.put("logical_height", new ByteTag(this.logicalHeight));
        if (protocolVersion >= 751) {
            attributes.remove("name");
            attributes.remove("fixed_time");
            attributes.remove("shrunk");
            attributes.put("effects", new StringTag(this.effects));
            attributes.put("coordinate_scale", new FloatTag(this.coordinateScale));
        }
        attributes.put("height", new IntTag(this.height));
        attributes.put("min_y", new IntTag(this.minY));
        if (protocolVersion >= 758) {
            attributes.put("infiniburn", new StringTag("#" + this.infiniburn));
        }
        if (protocolVersion >= 759) {
            attributes.put("monster_spawn_light_level", new IntTag(this.monster_spawn_light_level));
            attributes.put("monster_spawn_block_light_limit", new IntTag(this.monster_spawn_block_light_limit));
        }
        CompoundTag tag = new CompoundTag();
        for (Map.Entry entry : attributes.entrySet()) {
            tag.add((String)entry.getKey(), (SpecificTag)entry.getValue());
        }
        return tag;
    }

    private CompoundTag createBiomeRegistry(int protocol) {
        CompoundTag root = new CompoundTag();
        root.add("type", new StringTag("minecraft:worldgen/biome"));
        ArrayList<CompoundTag> biomes = new ArrayList<CompoundTag>();
        for (Biome biome : Biome.values()) {
            biomes.add(this.encodeBiome(biome, protocol));
        }
        root.add("value", new ListTag(10, biomes));
        return root;
    }

    private CompoundTag createChatRegistry(int protocol) {
        CompoundTag root = new CompoundTag();
        root.add("type", new StringTag("minecraft:chat_type"));
        CompoundTag systemChat = new CompoundTag();
        systemChat.add("name", new StringTag("minecraft:system"));
        systemChat.add("id", new IntTag(1));
        CompoundTag systemChatElement = new CompoundTag();
        CompoundTag systemChatData = new CompoundTag();
        if (protocol >= 760) {
            systemChatData.add("translation_key", new StringTag("chat.type.system"));
            systemChatData.add("parameters", new ListTag(8, Arrays.asList(new StringTag("sender"), new StringTag("content"))));
        }
        systemChatElement.add("chat", systemChatData);
        CompoundTag narration = new CompoundTag();
        if (protocol < 760) {
            narration.add("priority", new StringTag("system"));
        } else {
            narration.add("translation_key", new StringTag("chat.type.system.narrate"));
            narration.add("parameters", new ListTag(8, Arrays.asList(new StringTag("sender"), new StringTag("content"))));
        }
        systemChatElement.add("narration", narration);
        systemChat.add("element", systemChatElement);
        CompoundTag gameInfo = new CompoundTag();
        gameInfo.add("name", new StringTag("minecraft:game_info"));
        gameInfo.add("id", new IntTag(2));
        CompoundTag gameInfoElement = new CompoundTag();
        gameInfoElement.add("overlay", new CompoundTag());
        if (protocol >= 760) {
            CompoundTag gameInfoChat = new CompoundTag();
            gameInfoChat.add("translation_key", new StringTag("chat.type.game_info"));
            gameInfoChat.add("parameters", new ListTag(8, Collections.emptyList()));
            CompoundTag gameInfoNarration = new CompoundTag();
            gameInfoNarration.add("translation_key", new StringTag("chat.type.game_info.narrate"));
            gameInfoNarration.add("parameters", new ListTag(8, Collections.emptyList()));
            gameInfoElement.add("chat", gameInfoChat);
            gameInfoElement.add("narration", gameInfoNarration);
        }
        gameInfo.add("element", gameInfoElement);
        root.add("value", new ListTag(10, Arrays.asList(systemChat, gameInfo)));
        return root;
    }

    private CompoundTag encodeBiome(Biome biome, int protocol) {
        CompoundTag biomeTag = new CompoundTag();
        biomeTag.add("name", new StringTag(biome.getName()));
        biomeTag.add("id", new IntTag(biome.getId()));
        CompoundTag element = new CompoundTag();
        element.add("precipitation", new StringTag(biome.getPrecipitation()));
        if (protocol >= 762) {
            element.add("has_precipitation", new ByteTag(biome.getPrecipitation().equals("none") ? 0 : 1));
        }
        element.add("depth", new FloatTag(biome.getDepth()));
        element.add("temperature", new FloatTag(biome.getTemperature()));
        element.add("scale", new FloatTag(biome.getScale()));
        element.add("downfall", new FloatTag(biome.getDownfall()));
        element.add("category", new StringTag(biome.getCategory()));
        CompoundTag effects = new CompoundTag();
        effects.add("sky_color", new IntTag(biome.getSky_color()));
        effects.add("water_fog_color", new IntTag(biome.getWater_color()));
        effects.add("fog_color", new IntTag(biome.getFog_color()));
        effects.add("water_color", new IntTag(biome.getWater_color()));
        if (biome.getGrass_color_modifier() != null) {
            effects.add("grass_color_modifier", new StringTag(biome.getGrass_color_modifier()));
        }
        if (biome.getFoliage_color() != Integer.MIN_VALUE) {
            effects.add("foliage_color", new IntTag(biome.getFoliage_color()));
        }
        CompoundTag moodSound = new CompoundTag();
        moodSound.add("tick_delay", new IntTag(biome.getTick_delay()));
        moodSound.add("offset", new DoubleTag(biome.getOffset()));
        moodSound.add("block_search_extent", new IntTag(biome.getBlock_search_extent()));
        moodSound.add("sound", new StringTag(biome.getSound()));
        effects.add("mood_sound", moodSound);
        element.add("effects", effects);
        biomeTag.add("element", element);
        return biomeTag;
    }

    private ProtocolDimensionType(String key, int dimensionId, int id, boolean piglinSafe, boolean natural, float ambientLight, String infiniburn, boolean respawnAnchorWorks, boolean hasSkylight, boolean bedWorks, String effects, boolean hasRaids, int monster_spawn_light_level, int monster_spawn_block_light_limit, int logicalHeight, float coordinateScale, boolean ultrawarm, boolean hasCeiling, int minY, int height) {
        this.key = key;
        this.dimensionId = dimensionId;
        this.id = id;
        this.piglinSafe = piglinSafe;
        this.natural = natural;
        this.ambientLight = ambientLight;
        this.infiniburn = infiniburn;
        this.respawnAnchorWorks = respawnAnchorWorks;
        this.hasSkylight = hasSkylight;
        this.bedWorks = bedWorks;
        this.effects = effects;
        this.hasRaids = hasRaids;
        this.monster_spawn_light_level = monster_spawn_light_level;
        this.monster_spawn_block_light_limit = monster_spawn_block_light_limit;
        this.logicalHeight = logicalHeight;
        this.coordinateScale = coordinateScale;
        this.ultrawarm = ultrawarm;
        this.hasCeiling = hasCeiling;
        this.minY = minY;
        this.height = height;
    }

    public String getKey() {
        return this.key;
    }

    public int getDimensionId() {
        return this.dimensionId;
    }

    public int getId() {
        return this.id;
    }

    public boolean isPiglinSafe() {
        return this.piglinSafe;
    }

    public boolean isNatural() {
        return this.natural;
    }

    public float getAmbientLight() {
        return this.ambientLight;
    }

    public String getInfiniburn() {
        return this.infiniburn;
    }

    public boolean isRespawnAnchorWorks() {
        return this.respawnAnchorWorks;
    }

    public boolean isHasSkylight() {
        return this.hasSkylight;
    }

    public boolean isBedWorks() {
        return this.bedWorks;
    }

    public String getEffects() {
        return this.effects;
    }

    public boolean isHasRaids() {
        return this.hasRaids;
    }

    public int getMonster_spawn_light_level() {
        return this.monster_spawn_light_level;
    }

    public int getMonster_spawn_block_light_limit() {
        return this.monster_spawn_block_light_limit;
    }

    public int getLogicalHeight() {
        return this.logicalHeight;
    }

    public float getCoordinateScale() {
        return this.coordinateScale;
    }

    public boolean isUltrawarm() {
        return this.ultrawarm;
    }

    public boolean isHasCeiling() {
        return this.hasCeiling;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getHeight() {
        return this.height;
    }

    private static /* synthetic */ ProtocolDimensionType[] $values() {
        return new ProtocolDimensionType[]{OVERWORLD, THE_NETHER, THE_END};
    }

    static {
        DataInputStream dataInputStream;
        OVERWORLD = new ProtocolDimensionType("minecraft:overworld", 0, 0, false, true, 0.0f, "minecraft:infiniburn_overworld", false, true, true, "minecraft:overworld", true, 0, 0, 256, 1.0f, false, false, 0, 256);
        THE_NETHER = new ProtocolDimensionType("minecraft:the_nether", -1, 2, false, true, 0.0f, "minecraft:infiniburn_nether", false, true, true, "minecraft:the_nether", true, 0, 0, 256, 1.0f, false, false, 0, 256);
        THE_END = new ProtocolDimensionType("minecraft:the_end", 1, 3, false, true, 0.0f, "minecraft:infiniburn_end", false, true, true, "minecraft:the_end", true, 0, 0, 256, 1.0f, false, false, 0, 256);
        $VALUES = ProtocolDimensionType.$values();
        try {
            dataInputStream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(ProtocolDimensionType.class.getResourceAsStream("/damage-types-1.19.4.nbt"))));
            try {
                DAMAGE_TYPE_TAG_1_19_4 = (CompoundTag)CompoundTag.read(dataInputStream).get("");
            }
            finally {
                dataInputStream.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            dataInputStream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(ProtocolDimensionType.class.getResourceAsStream("/damage-types-1.20.nbt"))));
            try {
                DAMAGE_TYPE_TAG_1_20 = (CompoundTag)CompoundTag.read(dataInputStream).get("");
            }
            finally {
                dataInputStream.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum Biome {
        PLAINS("minecraft:plains", 1, "rain", 0.125f, 0.8f, 0.05f, 0.4f, "plains", 7907327, 329011, 12638463, 4159204, 6000, 2.0, 8, "minecraft:ambient.cave", null, Integer.MIN_VALUE),
        SWAMP("minecraft:swamp", 6, "rain", -0.2f, 0.8f, 0.1f, 0.9f, "swamp", 7907327, 2302743, 12638463, 6388580, 6000, 2.0, 8, "minecraft:ambient.cave", "swamp", 6975545),
        SWAMP_HILLS("minecraft:swamp_hills", 134, "rain", -0.1f, 0.8f, 0.3f, 0.9f, "swamp", 7907327, 2302743, 12638463, 6388580, 6000, 2.0, 8, "minecraft:ambient.cave", "swamp", 6975545),
        NETHER_WASTES("minecraft:nether_wastes", 8, "none", 0.1f, 2.0f, 0.2f, 0.0f, "nether", 7254527, 329011, 0x330808, 4159204, 6000, 2.0, 8, "minecraft:ambient.cave", "swamp", 6975545),
        THE_END("minecraft:the_end", 9, "none", 0.1f, 0.5f, 0.2f, 0.5f, "the_end", 7907327, 0xA080A0, 12638463, 4159204, 6000, 2.0, 8, "minecraft:ambient.cave", "swamp", 6975545);

        private final String name;
        private final int id;
        private final String precipitation;
        private final float depth;
        private final float temperature;
        private final float scale;
        private final float downfall;
        private final String category;
        private final int sky_color;
        private final int water_fog_color;
        private final int fog_color;
        private final int water_color;
        private final int tick_delay;
        private final double offset;
        private final int block_search_extent;
        private final String sound;
        private final String grass_color_modifier;
        private final int foliage_color;

        private Biome(String name, int id, String precipitation, float depth, float temperature, float scale, float downfall, String category, int sky_color, int water_fog_color, int fog_color, int water_color, int tick_delay, double offset, int block_search_extent, String sound, String grass_color_modifier, int foliage_color) {
            this.name = name;
            this.id = id;
            this.precipitation = precipitation;
            this.depth = depth;
            this.temperature = temperature;
            this.scale = scale;
            this.downfall = downfall;
            this.category = category;
            this.sky_color = sky_color;
            this.water_fog_color = water_fog_color;
            this.fog_color = fog_color;
            this.water_color = water_color;
            this.tick_delay = tick_delay;
            this.offset = offset;
            this.block_search_extent = block_search_extent;
            this.sound = sound;
            this.grass_color_modifier = grass_color_modifier;
            this.foliage_color = foliage_color;
        }

        public String getName() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }

        public String getPrecipitation() {
            return this.precipitation;
        }

        public float getDepth() {
            return this.depth;
        }

        public float getTemperature() {
            return this.temperature;
        }

        public float getScale() {
            return this.scale;
        }

        public float getDownfall() {
            return this.downfall;
        }

        public String getCategory() {
            return this.category;
        }

        public int getSky_color() {
            return this.sky_color;
        }

        public int getWater_fog_color() {
            return this.water_fog_color;
        }

        public int getFog_color() {
            return this.fog_color;
        }

        public int getWater_color() {
            return this.water_color;
        }

        public int getTick_delay() {
            return this.tick_delay;
        }

        public double getOffset() {
            return this.offset;
        }

        public int getBlock_search_extent() {
            return this.block_search_extent;
        }

        public String getSound() {
            return this.sound;
        }

        public String getGrass_color_modifier() {
            return this.grass_color_modifier;
        }

        public int getFoliage_color() {
            return this.foliage_color;
        }
    }
}

