/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.protocol;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.protocol.DefinedPacket;
import net.shieldcommunity.nullcordx.protocol.Metadata;
import net.shieldcommunity.nullcordx.protocol.ProtocolItemType;
import se.llbit.nbt.Tag;

public class SlotData
implements Metadata {
    private final ProtocolItemType itemType;
    private final int count;
    private final int data;

    @Override
    public void writeMetadata(ByteBuf buf, int protocol) {
        boolean present;
        int id = this.itemType != null ? this.itemType.getIdByProtocol(protocol) : 0;
        boolean bl = present = id > 0;
        if (protocol >= 404) {
            buf.writeBoolean(present);
        }
        if (!present && protocol < 404) {
            buf.writeShort(-1);
        }
        if (present) {
            if (protocol < 404) {
                buf.writeShort(id);
            } else {
                DefinedPacket.writeVarInt(id, buf);
            }
            buf.writeByte(this.count);
            if (protocol < 393) {
                buf.writeShort(this.data);
            }
            if (protocol < 393) {
                buf.writeByte(0);
                return;
            }
            Tag tag = this.itemType.getNbtTag(protocol, this.data);
            if (tag != null) {
                if (protocol >= 764) {
                    DefinedPacket.writeNamelessTag(tag, buf);
                } else {
                    DefinedPacket.writeTag(tag, buf, protocol);
                }
            }
        }
    }

    public SlotData(ProtocolItemType itemType, int count, int data) {
        this.itemType = itemType;
        this.count = count;
        this.data = data;
    }

    public String toString() {
        return "SlotData(itemType=" + this.itemType + ", count=" + this.count + ", data=" + this.data + ")";
    }
}

