/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.protocol.packets;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.shieldcommunity.nullcordx.protocol.ProtocolPosition;

public class DefaultSpawnPositionPacket
extends DefinedPacket {
    private ProtocolPosition position;
    private float angle;

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int version) {
        this.position.write(buf, version);
        if (version > 754) {
            buf.writeFloat(this.angle);
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        throw new UnsupportedOperationException();
    }

    public ProtocolPosition getPosition() {
        return this.position;
    }

    public float getAngle() {
        return this.angle;
    }

    public void setPosition(ProtocolPosition position) {
        this.position = position;
    }

    public void setAngle(float angle) {
        this.angle = angle;
    }

    @Override
    public String toString() {
        return "DefaultSpawnPositionPacket(position=" + this.getPosition() + ", angle=" + this.getAngle() + ")";
    }

    public DefaultSpawnPositionPacket() {
    }

    public DefaultSpawnPositionPacket(ProtocolPosition position, float angle) {
        this.position = position;
        this.angle = angle;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultSpawnPositionPacket)) {
            return false;
        }
        DefaultSpawnPositionPacket other = (DefaultSpawnPositionPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getAngle(), other.getAngle()) != 0) {
            return false;
        }
        ProtocolPosition this$position = this.getPosition();
        ProtocolPosition other$position = other.getPosition();
        return !(this$position == null ? other$position != null : !((Object)this$position).equals(other$position));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultSpawnPositionPacket;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getAngle());
        ProtocolPosition $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : ((Object)$position).hashCode());
        return result;
    }
}

