/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.protocol.packets;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public class PlayerAbilitiesPacket
extends DefinedPacket {
    private static final int FLAG_INVINCIBLE = 1;
    private static final int FLAG_FLYING = 2;
    private static final int FLAG_CAN_FLY = 4;
    private static final int FLAG_CREATIVE = 8;
    private boolean invincible;
    private boolean canFly;
    private boolean flying;
    private boolean creative;
    private float flySpeed;
    private float walkSpeed;

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        int flags = 0;
        if (this.invincible) {
            flags |= 1;
        }
        if (this.canFly) {
            flags |= 4;
        }
        if (this.flying) {
            flags |= 2;
        }
        if (this.creative) {
            flags |= 8;
        }
        buf.writeByte(flags);
        buf.writeFloat(this.flySpeed);
        buf.writeFloat(this.walkSpeed);
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        throw new UnsupportedOperationException();
    }

    public boolean isInvincible() {
        return this.invincible;
    }

    public boolean isCanFly() {
        return this.canFly;
    }

    public boolean isFlying() {
        return this.flying;
    }

    public boolean isCreative() {
        return this.creative;
    }

    public float getFlySpeed() {
        return this.flySpeed;
    }

    public float getWalkSpeed() {
        return this.walkSpeed;
    }

    public void setInvincible(boolean invincible) {
        this.invincible = invincible;
    }

    public void setCanFly(boolean canFly) {
        this.canFly = canFly;
    }

    public void setFlying(boolean flying) {
        this.flying = flying;
    }

    public void setCreative(boolean creative) {
        this.creative = creative;
    }

    public void setFlySpeed(float flySpeed) {
        this.flySpeed = flySpeed;
    }

    public void setWalkSpeed(float walkSpeed) {
        this.walkSpeed = walkSpeed;
    }

    @Override
    public String toString() {
        return "PlayerAbilitiesPacket(invincible=" + this.isInvincible() + ", canFly=" + this.isCanFly() + ", flying=" + this.isFlying() + ", creative=" + this.isCreative() + ", flySpeed=" + this.getFlySpeed() + ", walkSpeed=" + this.getWalkSpeed() + ")";
    }

    public PlayerAbilitiesPacket() {
    }

    public PlayerAbilitiesPacket(boolean invincible, boolean canFly, boolean flying, boolean creative, float flySpeed, float walkSpeed) {
        this.invincible = invincible;
        this.canFly = canFly;
        this.flying = flying;
        this.creative = creative;
        this.flySpeed = flySpeed;
        this.walkSpeed = walkSpeed;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlayerAbilitiesPacket)) {
            return false;
        }
        PlayerAbilitiesPacket other = (PlayerAbilitiesPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isInvincible() != other.isInvincible()) {
            return false;
        }
        if (this.isCanFly() != other.isCanFly()) {
            return false;
        }
        if (this.isFlying() != other.isFlying()) {
            return false;
        }
        if (this.isCreative() != other.isCreative()) {
            return false;
        }
        if (Float.compare(this.getFlySpeed(), other.getFlySpeed()) != 0) {
            return false;
        }
        return Float.compare(this.getWalkSpeed(), other.getWalkSpeed()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof PlayerAbilitiesPacket;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isInvincible() ? 79 : 97);
        result = result * 59 + (this.isCanFly() ? 79 : 97);
        result = result * 59 + (this.isFlying() ? 79 : 97);
        result = result * 59 + (this.isCreative() ? 79 : 97);
        result = result * 59 + Float.floatToIntBits(this.getFlySpeed());
        result = result * 59 + Float.floatToIntBits(this.getWalkSpeed());
        return result;
    }
}

