/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.protocol.packets;

import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import java.util.UUID;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public class PlayerInfoPacket
extends DefinedPacket {
    private String username;
    private UUID uuid;
    private int latency;

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int version) {
        if (version >= 761) {
            EnumSet<Action> actions = EnumSet.noneOf(Action.class);
            actions.add(Action.ADD_PLAYER);
            actions.add(Action.UPDATE_GAMEMODE);
            actions.add(Action.UPDATE_LISTED);
            actions.add(Action.UPDATE_LATENCY);
            PlayerInfoPacket.writeEnumSet(actions, Action.class, buf);
            PlayerInfoPacket.writeVarInt(1, buf);
            PlayerInfoPacket.writeUUID(this.uuid, buf);
            PlayerInfoPacket.writeString(this.username, buf);
            PlayerInfoPacket.writeVarInt(0, buf);
            PlayerInfoPacket.writeVarInt(3, buf);
            buf.writeBoolean(true);
            PlayerInfoPacket.writeVarInt(this.latency, buf);
            return;
        }
        PlayerInfoPacket.writeVarInt(0, buf);
        PlayerInfoPacket.writeVarInt(1, buf);
        PlayerInfoPacket.writeUUID(this.uuid, buf);
        PlayerInfoPacket.writeString(this.username, buf);
        PlayerInfoPacket.writeVarInt(0, buf);
        PlayerInfoPacket.writeVarInt(3, buf);
        PlayerInfoPacket.writeVarInt(this.latency, buf);
        buf.writeBoolean(false);
        if (version >= 759) {
            buf.writeBoolean(false);
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        throw new UnsupportedOperationException();
    }

    public String getUsername() {
        return this.username;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public int getLatency() {
        return this.latency;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public void setLatency(int latency) {
        this.latency = latency;
    }

    @Override
    public String toString() {
        return "PlayerInfoPacket(username=" + this.getUsername() + ", uuid=" + this.getUuid() + ", latency=" + this.getLatency() + ")";
    }

    public PlayerInfoPacket() {
    }

    public PlayerInfoPacket(String username, UUID uuid, int latency) {
        this.username = username;
        this.uuid = uuid;
        this.latency = latency;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlayerInfoPacket)) {
            return false;
        }
        PlayerInfoPacket other = (PlayerInfoPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLatency() != other.getLatency()) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        UUID this$uuid = this.getUuid();
        UUID other$uuid = other.getUuid();
        return !(this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PlayerInfoPacket;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLatency();
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        UUID $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
        return result;
    }

    private static enum Action {
        ADD_PLAYER,
        INITIALIZE_CHAT,
        UPDATE_GAMEMODE,
        UPDATE_LISTED,
        UPDATE_LATENCY,
        UPDATE_DISPLAY_NAME;

    }
}

