/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.protocol.packets;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public class PongTransactionPacket
extends DefinedPacket {
    private byte windowId = 0;
    private int id;
    private boolean accepted = true;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        if (protocolVersion < 755) {
            this.windowId = buf.readByte();
            this.id = buf.readShort();
            this.accepted = buf.readBoolean();
            return;
        }
        this.id = buf.readInt();
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public byte getWindowId() {
        return this.windowId;
    }

    public int getId() {
        return this.id;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public void setWindowId(byte windowId) {
        this.windowId = windowId;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setAccepted(boolean accepted) {
        this.accepted = accepted;
    }

    @Override
    public String toString() {
        return "PongTransactionPacket(windowId=" + this.getWindowId() + ", id=" + this.getId() + ", accepted=" + this.isAccepted() + ")";
    }

    public PongTransactionPacket() {
    }

    public PongTransactionPacket(byte windowId, int id, boolean accepted) {
        this.windowId = windowId;
        this.id = id;
        this.accepted = accepted;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PongTransactionPacket)) {
            return false;
        }
        PongTransactionPacket other = (PongTransactionPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWindowId() != other.getWindowId()) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        return this.isAccepted() == other.isAccepted();
    }

    protected boolean canEqual(Object other) {
        return other instanceof PongTransactionPacket;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getWindowId();
        result = result * 59 + this.getId();
        result = result * 59 + (this.isAccepted() ? 79 : 97);
        return result;
    }
}

