/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public final class HttpUtils {
    private static final int DEFAULT_TIMEOUT = 10000;

    public static HttpByteArrayInputStream makeRequest(HttpUriRequest request) throws IOException {
        return HttpUtils.makeRequest(request, 10000);
    }

    public static HttpByteArrayInputStream makeRequest(HttpUriRequest request, int timeout) throws IOException {
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).setSocketTimeout(timeout).build()).build();){
            HttpByteArrayInputStream httpByteArrayInputStream;
            block12: {
                CloseableHttpResponse response = httpClient.execute(request);
                try {
                    httpByteArrayInputStream = new HttpByteArrayInputStream(EntityUtils.toByteArray(response.getEntity()), response.getStatusLine().getStatusCode());
                    if (response == null) break block12;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return httpByteArrayInputStream;
        }
    }

    public static InputStream getInputStream(URLConnection urlConnection) throws IOException {
        InputStream inputStream = null;
        if (urlConnection instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
            inputStream = httpURLConnection.getErrorStream();
        }
        if (inputStream == null) {
            inputStream = urlConnection.getInputStream();
        }
        return inputStream;
    }

    private HttpUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class HttpByteArrayInputStream
    extends ByteArrayInputStream {
        private final byte[] originalBuf;
        private final int code;

        public HttpByteArrayInputStream(byte[] buf, int code) {
            super(buf);
            this.originalBuf = buf;
            this.code = code;
        }

        public String getTextResponse() {
            return new String(this.originalBuf, StandardCharsets.UTF_8);
        }

        public byte[] getOriginalBuf() {
            return this.originalBuf;
        }

        public int getCode() {
            return this.code;
        }
    }
}

