/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.utils;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.DataBufferInt;
import java.util.List;
import net.shieldcommunity.nullcordx.libs.imgscalr.Scalr;

public final class ImageUtils {
    public static BufferedImage[] splitImage(BufferedImage image, int rows, int columns) {
        int chunkWidth = image.getWidth() / rows;
        int chunkHeight = image.getHeight() / columns;
        int count = 0;
        int chunks = columns * rows;
        BufferedImage[] images = new BufferedImage[chunks];
        for (int x = 0; x < columns; ++x) {
            for (int y = 0; y < rows; ++y) {
                BufferedImage chunk = new BufferedImage(chunkWidth, chunkHeight, 2);
                Graphics2D gr = chunk.createGraphics();
                gr.drawImage(image, 0, 0, chunkWidth, chunkHeight, chunkWidth * y, chunkHeight * x, chunkWidth * y + chunkWidth, chunkHeight * x + chunkHeight, null);
                gr.dispose();
                images[count] = chunk;
                ++count;
            }
        }
        return images;
    }

    public static BufferedImage restoreSplitImage(List<BufferedImage> split, int rows, int columns) {
        BufferedImage firstChunk = split.get(0);
        int chunkWidth = firstChunk.getWidth();
        int chunkHeight = firstChunk.getHeight();
        int imageWidth = chunkWidth * rows;
        int imageHeight = chunkHeight * columns;
        BufferedImage newImage = new BufferedImage(imageWidth, imageHeight, 2);
        int chunkIndex = 0;
        for (int y = 0; y < columns; ++y) {
            for (int x = 0; x < rows; ++x) {
                BufferedImage chunk = split.get(chunkIndex);
                Graphics2D gr = newImage.createGraphics();
                gr.drawImage((Image)chunk, chunkWidth * x, chunkHeight * y, null);
                gr.dispose();
                ++chunkIndex;
            }
        }
        return newImage;
    }

    public static BufferedImage rotateImageByDegrees(BufferedImage img, int degrees2) {
        BufferedImage newImage = new BufferedImage(img.getWidth(), img.getHeight(), img.getType());
        ImageUtils.doImageRotation(img, newImage, degrees2);
        return newImage;
    }

    private static void doImageRotation(BufferedImage img, BufferedImage newImage, int degrees2) {
        int width = img.getWidth();
        int height = img.getHeight();
        Graphics2D g2 = newImage.createGraphics();
        g2.rotate(Math.toRadians(degrees2), (double)width / 2.0, (double)height / 2.0);
        g2.drawImage(img, null, 0, 0);
        g2.dispose();
    }

    public static BufferedImage copyImage(BufferedImage image) {
        BufferedImage copy = new BufferedImage(image.getWidth(), image.getHeight(), image.getType());
        int[] destArray = ((DataBufferInt)copy.getRaster().getDataBuffer()).getData();
        int[] srcArray = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        ImageUtils.doCopy(srcArray, destArray);
        return copy;
    }

    private static void doCopy(int[] src, int[] dest) {
        System.arraycopy(src, 0, dest, 0, src.length);
    }

    public static BufferedImage resizeImage(BufferedImage image, int width, int height, Scalr.Method method) {
        BufferedImage resizedImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        Graphics2D graphics = resizedImage.createGraphics();
        graphics.drawImage((Image)image, 0, 0, null);
        graphics.dispose();
        if (resizedImage.getWidth() == width && resizedImage.getHeight() == height) {
            return resizedImage;
        }
        return ImageUtils.copyImage(Scalr.resize(resizedImage, method, Scalr.Mode.FIT_EXACT, width, height, new BufferedImageOp[0]));
    }

    public static void drawRawNewImageToOld(int width, int height, int[] image, int[] newImage, boolean ignoreTransparent) {
        for (int y = 0; y < width; ++y) {
            for (int x = 0; x < height; ++x) {
                int newPixel = newImage[x * width + y];
                if (newPixel == 0) continue;
                if (!ignoreTransparent) {
                    image[x * width + y] = newPixel;
                    continue;
                }
                int pixel = image[x * width + y];
                if (pixel == 0) continue;
                image[x * width + y] = newPixel;
            }
        }
    }

    private ImageUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

