/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.api.app.component;

import com.mrcrayfish.device.api.app.Component;
import com.mrcrayfish.device.core.Laptop;
import com.mrcrayfish.device.util.GuiHelper;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.TextFormatting;

public class Text
extends Component {
    protected String rawText;
    protected List<String> lines;
    protected int width;
    protected int padding;
    protected boolean shadow = false;
    protected int textColor = Color.WHITE.getRGB();
    private WordListener wordListener = null;

    public Text(String text, int left, int top, int width) {
        super(left, top);
        this.width = width;
        this.setText(text);
    }

    @Override
    public void render(Laptop laptop, Minecraft mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
        if (this.visible) {
            for (int i = 0; i < this.lines.size(); ++i) {
                String text;
                for (text = this.lines.get(i); text != null && text.endsWith("\n"); text = text.substring(0, text.length() - 1)) {
                }
                Laptop.fontRenderer.func_175065_a(text, (float)(x + this.padding), (float)(y + i * 10 + this.padding), this.textColor, this.shadow);
            }
        }
    }

    public void setText(String text) {
        this.rawText = text;
        text = text.replace("\\n", "\n");
        this.lines = Laptop.fontRenderer.func_78271_c(text, this.width - this.padding * 2);
    }

    public void setTextColor(Color color) {
        this.textColor = color.getRGB();
    }

    public void setShadow(boolean shadow) {
        this.shadow = shadow;
    }

    public void setPadding(int padding) {
        this.padding = padding;
        this.updateLines();
    }

    private void updateLines() {
        this.setText(this.rawText);
    }

    @Override
    protected void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        int lineIndex;
        if (GuiHelper.isMouseWithin(mouseX, mouseY, this.xPosition + this.padding, this.yPosition + this.padding, this.width - this.padding * 2, this.getHeight() - this.padding * 2) && this.wordListener != null && this.lines.size() > 0 && (lineIndex = (mouseY - (this.yPosition + this.padding)) / 10) < this.lines.size()) {
            int index;
            int cursorX = mouseX - (this.xPosition + this.padding);
            String line = this.lines.get(lineIndex);
            String clickedWord = this.getWord(line, index = Laptop.fontRenderer.func_78269_a(line, cursorX).length());
            if (clickedWord != null) {
                this.wordListener.onWordClicked(clickedWord, mouseButton);
            }
        }
    }

    private String getWord(String line, int index) {
        int startIndex;
        if (index >= line.length() || line.charAt(index) == ' ') {
            return null;
        }
        for (startIndex = index; startIndex > 0 && line.charAt(startIndex - 1) != ' '; --startIndex) {
        }
        int endIndex = index;
        while (endIndex + 1 < line.length() && line.charAt(endIndex + 1) != ' ') {
            ++endIndex;
        }
        endIndex = Math.min(endIndex + 1, line.length());
        return TextFormatting.func_110646_a((String)line.substring(startIndex, endIndex));
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.lines.size() * Minecraft.func_71410_x().field_71466_p.field_78288_b + this.lines.size() - 1 + this.padding * 2;
    }

    public void setWordListener(WordListener wordListener) {
        this.wordListener = wordListener;
    }

    public static interface WordListener {
        public void onWordClicked(String var1, int var2);
    }
}

