/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.api.io;

import com.mrcrayfish.device.api.io.Folder;
import com.mrcrayfish.device.core.io.FileSystem;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;

public class Drive {
    private String name;
    private UUID uuid;
    private Type type;
    private Folder root;
    private boolean synced = false;

    public Drive(NBTTagCompound driveTag) {
        this.name = driveTag.func_74779_i("name");
        this.uuid = UUID.fromString(driveTag.func_74779_i("uuid"));
        this.type = Type.fromString(driveTag.func_74779_i("type"));
    }

    public String getName() {
        return this.name;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public Type getType() {
        return this.type;
    }

    public Folder getRoot() {
        return this.root;
    }

    public void syncRoot(Folder root) {
        if (!this.synced) {
            this.root = root;
            root.setDrive(this);
            root.validate();
            this.synced = true;
        }
    }

    public boolean isSynced() {
        return this.synced;
    }

    @Nullable
    public final Folder getFolder(String path) {
        if (path == null) {
            throw new IllegalArgumentException("The path can not be null");
        }
        if (!FileSystem.PATTERN_DIRECTORY.matcher(path).matches()) {
            throw new IllegalArgumentException("The path \"" + path + "\" does not follow the correct format");
        }
        if (path.equals("/")) {
            return this.root;
        }
        Folder prev = this.root;
        String[] folders = path.split("/");
        if (folders.length > 0 && folders.length <= 10) {
            for (int i = 1; i < folders.length; ++i) {
                Folder temp = prev.getFolder(folders[i]);
                if (temp == null) {
                    return null;
                }
                prev = temp;
            }
            return prev;
        }
        return null;
    }

    public String toString() {
        return this.name;
    }

    public static enum Type {
        INTERNAL,
        EXTERNAL,
        NETWORK,
        UNKNOWN;


        public static Type fromString(String type) {
            for (Type t : Type.values()) {
                if (!t.toString().equals(type)) continue;
                return t;
            }
            return UNKNOWN;
        }
    }
}

