/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.api.utils;

import com.mrcrayfish.device.util.StreamUtils;
import java.io.IOException;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class OnlineRequest {
    private static OnlineRequest instance = null;
    private final Queue<RequestWrapper> requests = new ConcurrentLinkedQueue<RequestWrapper>();
    private Thread thread;
    private boolean running = true;

    private OnlineRequest() {
        this.start();
    }

    public static OnlineRequest getInstance() {
        if (instance == null) {
            instance = new OnlineRequest();
        }
        return instance;
    }

    public static void checkURLForSuspicions(URL url) throws IOException {
        System.out.println(url.getHost());
        if (!OnlineRequest.isSafe(url.getHost())) {
            throw new IOException();
        }
    }

    private static boolean isSafe(String host) {
        switch (host) {
            case "ultreon.gitlab.io": 
            case "cdn.discordapp.com": 
            case "jab125.com": 
            case "raw.githubusercontent.com": 
            case "github.com": 
            case "i.imgur.com": 
            case "avatars1.githubusercontent.com": {
                return true;
            }
        }
        return false;
    }

    private void start() {
        this.thread = new Thread((Runnable)new RequestRunnable(), "Online Request Thread");
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void make(String url, ResponseHandler handler) {
        Queue<RequestWrapper> queue = this.requests;
        synchronized (queue) {
            this.requests.offer(new RequestWrapper(url, handler));
            this.requests.notify();
        }
    }

    public static interface ResponseHandler {
        public void handle(boolean var1, String var2);
    }

    private static class RequestWrapper {
        public final String url;
        public final ResponseHandler handler;

        public RequestWrapper(String url, ResponseHandler handler) {
            this.url = url;
            this.handler = handler;
        }
    }

    private class RequestRunnable
    implements Runnable {
        private RequestRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (OnlineRequest.this.running) {
                try {
                    Queue queue = OnlineRequest.this.requests;
                    synchronized (queue) {
                        OnlineRequest.this.requests.wait();
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
                while (!OnlineRequest.this.requests.isEmpty()) {
                    RequestWrapper wrapper = (RequestWrapper)OnlineRequest.this.requests.poll();
                    try {
                        URL url = new URL(wrapper.url);
                        OnlineRequest.checkURLForSuspicions(url);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        wrapper.handler.handle(false, "DOMAIN NOT BLACKLISTED/ERROR PARSING DOMAIN");
                        continue;
                    }
                    try {
                        CloseableHttpClient client = HttpClients.custom().setHostnameVerifier(new X509HostnameVerifier(){

                            public void verify(String host, SSLSocket ssl) throws IOException {
                            }

                            public void verify(String host, X509Certificate cert) throws SSLException {
                            }

                            public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
                            }

                            public boolean verify(String hostname, SSLSession session) {
                                return true;
                            }
                        }).setSslcontext(new SSLContextBuilder().loadTrustMaterial(null, (chain, authType) -> true).build()).build();
                        Throwable throwable = null;
                        try {
                            HttpGet get = new HttpGet(wrapper.url);
                            CloseableHttpResponse response = client.execute((HttpUriRequest)get);
                            Throwable throwable2 = null;
                            try {
                                String raw = StreamUtils.convertToString(response.getEntity().getContent());
                                wrapper.handler.handle(true, raw);
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (response == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        response.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                    continue;
                                }
                                response.close();
                            }
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (client == null) continue;
                            if (throwable != null) {
                                try {
                                    client.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                                continue;
                            }
                            client.close();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        wrapper.handler.handle(false, "");
                    }
                }
            }
        }
    }
}

