/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.core.io.drive;

import com.mrcrayfish.device.core.io.ServerFolder;
import com.mrcrayfish.device.core.io.drive.AbstractDrive;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public final class ExternalDrive
extends AbstractDrive {
    private static final Predicate<NBTTagCompound> PREDICATE_DRIVE_TAG = tag -> tag.func_150297_b("name", 8) && tag.func_150297_b("uuid", 8) && tag.func_150297_b("root", 10);

    private ExternalDrive() {
    }

    public ExternalDrive(String displayName) {
        super(displayName);
    }

    @Nullable
    public static AbstractDrive fromTag(NBTTagCompound driveTag) {
        if (!PREDICATE_DRIVE_TAG.test(driveTag)) {
            return null;
        }
        ExternalDrive drive = new ExternalDrive();
        drive.name = driveTag.func_74779_i("name");
        drive.uuid = UUID.fromString(driveTag.func_74779_i("uuid"));
        NBTTagCompound folderTag = driveTag.func_74775_l("root");
        drive.root = ServerFolder.fromTag(folderTag.func_74779_i("file_name"), folderTag.func_74775_l("data"));
        return drive;
    }

    @Override
    public NBTTagCompound toTag() {
        NBTTagCompound driveTag = new NBTTagCompound();
        driveTag.func_74778_a("name", this.name);
        driveTag.func_74778_a("uuid", this.uuid.toString());
        NBTTagCompound folderTag = new NBTTagCompound();
        folderTag.func_74778_a("file_name", this.root.getName());
        folderTag.func_74782_a("data", (NBTBase)this.root.toTag());
        driveTag.func_74782_a("root", (NBTBase)folderTag);
        return driveTag;
    }

    @Override
    public AbstractDrive.Type getType() {
        return AbstractDrive.Type.EXTERNAL;
    }
}

