/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.core.network.task;

import com.mrcrayfish.device.api.task.Task;
import com.mrcrayfish.device.core.network.NetworkDevice;
import com.mrcrayfish.device.core.network.Router;
import com.mrcrayfish.device.tileentity.TileEntityNetworkDevice;
import java.util.Collection;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TaskGetDevices
extends Task {
    private BlockPos devicePos;
    private Class<? extends TileEntityNetworkDevice> targetDeviceClass;
    private Collection<NetworkDevice> foundDevices;

    private TaskGetDevices() {
        super("get_network_devices");
    }

    public TaskGetDevices(BlockPos devicePos) {
        this();
        this.devicePos = devicePos;
    }

    public TaskGetDevices(BlockPos devicePos, Class<? extends TileEntityNetworkDevice> targetDeviceClass) {
        this();
        this.devicePos = devicePos;
        this.targetDeviceClass = targetDeviceClass;
    }

    @Override
    public void prepareRequest(NBTTagCompound nbt) {
        nbt.func_74772_a("devicePos", this.devicePos.func_177986_g());
        if (this.targetDeviceClass != null) {
            nbt.func_74778_a("targetClass", this.targetDeviceClass.getName());
        }
    }

    @Override
    public void processRequest(NBTTagCompound nbt, World world, EntityPlayer player) {
        Router router;
        TileEntityNetworkDevice tileEntityNetworkDevice;
        BlockPos devicePos = BlockPos.func_177969_a((long)nbt.func_74763_f("devicePos"));
        Class<?> targetDeviceClass = null;
        try {
            Class<?> targetClass = Class.forName(nbt.func_74779_i("targetClass"));
            if (TileEntityNetworkDevice.class.isAssignableFrom(targetClass)) {
                targetDeviceClass = targetClass;
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        TileEntity tileEntity = world.func_175625_s(devicePos);
        if (tileEntity instanceof TileEntityNetworkDevice && (tileEntityNetworkDevice = (TileEntityNetworkDevice)tileEntity).isConnected() && (router = tileEntityNetworkDevice.getRouter()) != null) {
            this.foundDevices = targetDeviceClass != null ? router.getConnectedDevices(world, targetDeviceClass) : router.getConnectedDevices(world);
            this.setSuccessful();
        }
    }

    @Override
    public void prepareResponse(NBTTagCompound nbt) {
        if (this.isSucessful()) {
            NBTTagList deviceList = new NBTTagList();
            this.foundDevices.forEach(device -> deviceList.func_74742_a((NBTBase)device.toTag(true)));
            nbt.func_74782_a("network_devices", (NBTBase)deviceList);
        }
    }

    @Override
    public void processResponse(NBTTagCompound nbt) {
    }
}

