/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.item;

import com.mrcrayfish.device.DeviceConfig;
import com.mrcrayfish.device.MrCrayfishDeviceMod;
import com.mrcrayfish.device.core.network.Router;
import com.mrcrayfish.device.tileentity.TileEntityNetworkDevice;
import com.mrcrayfish.device.tileentity.TileEntityRouter;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketChat;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemEthernetCable
extends Item {
    public ItemEthernetCable() {
        this.func_77655_b("ethernet_cable");
        this.setRegistryName("ethernet_cable");
        this.func_77637_a(MrCrayfishDeviceMod.TAB_DEVICE);
        this.func_77625_d(1);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (!world.field_72995_K) {
            ItemStack heldItem = player.func_184586_b(hand);
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof TileEntityRouter) {
                if (!heldItem.func_77942_o()) {
                    this.sendGameInfoMessage(player, "message.invalid_cable");
                    return EnumActionResult.SUCCESS;
                }
                TileEntityRouter tileEntityRouter = (TileEntityRouter)tileEntity;
                Router router = tileEntityRouter.getRouter();
                NBTTagCompound tag = heldItem.func_77978_p();
                BlockPos devicePos = BlockPos.func_177969_a((long)tag.func_74763_f("pos"));
                TileEntity tileEntity1 = world.func_175625_s(devicePos);
                if (tileEntity1 instanceof TileEntityNetworkDevice) {
                    TileEntityNetworkDevice tileEntityNetworkDevice = (TileEntityNetworkDevice)tileEntity1;
                    if (!router.isDeviceRegistered(tileEntityNetworkDevice)) {
                        if (router.addDevice(tileEntityNetworkDevice)) {
                            tileEntityNetworkDevice.connect(router);
                            heldItem.func_190918_g(1);
                            if (ItemEthernetCable.getDistance(tileEntity1.func_174877_v(), tileEntityRouter.func_174877_v()) > (double)DeviceConfig.getSignalRange()) {
                                this.sendGameInfoMessage(player, "message.successful_registered");
                            } else {
                                this.sendGameInfoMessage(player, "message.successful_connection");
                            }
                        } else {
                            this.sendGameInfoMessage(player, "message.router_max_devices");
                        }
                    } else {
                        this.sendGameInfoMessage(player, "message.device_already_connected");
                    }
                } else if (router.addDevice(tag.func_186857_a("id"), tag.func_74779_i("name"))) {
                    heldItem.func_190918_g(1);
                    this.sendGameInfoMessage(player, "message.successful_registered");
                } else {
                    this.sendGameInfoMessage(player, "message.router_max_devices");
                }
                return EnumActionResult.SUCCESS;
            }
            if (tileEntity instanceof TileEntityNetworkDevice) {
                TileEntityNetworkDevice tileEntityNetworkDevice = (TileEntityNetworkDevice)tileEntity;
                heldItem.func_77982_d(new NBTTagCompound());
                NBTTagCompound tag = heldItem.func_77978_p();
                tag.func_186854_a("id", tileEntityNetworkDevice.getId());
                tag.func_74778_a("name", tileEntityNetworkDevice.getCustomName());
                tag.func_74772_a("pos", tileEntityNetworkDevice.func_174877_v().func_177986_g());
                this.sendGameInfoMessage(player, "message.select_router");
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.SUCCESS;
    }

    private void sendGameInfoMessage(EntityPlayer player, String message) {
        if (player instanceof EntityPlayerMP) {
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketChat((ITextComponent)new TextComponentTranslation(message, new Object[0]), ChatType.GAME_INFO));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K) {
            ItemStack heldItem = player.func_184586_b(hand);
            if (player.func_70093_af()) {
                heldItem.func_135074_t();
                heldItem.func_77982_d(null);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)heldItem);
            }
        }
        return super.func_77659_a(world, player, hand);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p();
            if (tag != null) {
                tooltip.add(TextFormatting.RED.toString() + TextFormatting.BOLD.toString() + "ID: " + TextFormatting.RESET.toString() + tag.func_186857_a("id"));
                tooltip.add(TextFormatting.RED.toString() + TextFormatting.BOLD.toString() + "Device: " + TextFormatting.RESET.toString() + tag.func_74779_i("name"));
                BlockPos devicePos = BlockPos.func_177969_a((long)tag.func_74763_f("pos"));
                StringBuilder builder = new StringBuilder();
                builder.append(TextFormatting.RED.toString() + TextFormatting.BOLD.toString() + "X: " + TextFormatting.RESET.toString() + devicePos.func_177958_n() + " ");
                builder.append(TextFormatting.RED.toString() + TextFormatting.BOLD.toString() + "Y: " + TextFormatting.RESET.toString() + devicePos.func_177956_o() + " ");
                builder.append(TextFormatting.RED.toString() + TextFormatting.BOLD.toString() + "Z: " + TextFormatting.RESET.toString() + devicePos.func_177952_p());
                tooltip.add(builder.toString());
            }
        } else {
            if (!GuiScreen.func_146272_n()) {
                tooltip.add(TextFormatting.GRAY.toString() + "Use this cable to connect");
                tooltip.add(TextFormatting.GRAY.toString() + "a device to a router.");
                tooltip.add(TextFormatting.YELLOW.toString() + "Hold SHIFT for How-To");
                return;
            }
            tooltip.add(TextFormatting.GRAY.toString() + "Start by right clicking a");
            tooltip.add(TextFormatting.GRAY.toString() + "device with this cable");
            tooltip.add(TextFormatting.GRAY.toString() + "then right click the ");
            tooltip.add(TextFormatting.GRAY.toString() + "router you want to");
            tooltip.add(TextFormatting.GRAY.toString() + "connect this device to.");
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return stack.func_77942_o();
    }

    private static double getDistance(BlockPos source, BlockPos target) {
        return Math.sqrt(source.func_177957_d((double)target.func_177958_n() + 0.5, (double)target.func_177956_o() + 0.5, (double)target.func_177952_p() + 0.5));
    }

    public String func_77653_i(ItemStack stack) {
        if (stack.func_77942_o()) {
            return TextFormatting.GRAY.toString() + TextFormatting.BOLD.toString() + super.func_77653_i(stack);
        }
        return super.func_77653_i(stack);
    }
}

