/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.object;

import com.mrcrayfish.device.api.io.File;
import java.awt.Color;
import java.util.Arrays;
import net.minecraft.nbt.NBTTagCompound;

public class Picture {
    private File source;
    private String name;
    private String author;
    public int[] pixels;
    public Size size;

    public Picture(String name, String author, Size size) {
        this.name = name;
        this.author = author;
        this.pixels = new int[size.width * size.height];
        this.size = size;
        this.init();
    }

    private void init() {
        Arrays.fill(this.pixels, new Color(1.0f, 1.0f, 1.0f, 0.0f).getRGB());
    }

    public File getSource() {
        return this.source;
    }

    public String getName() {
        return this.name;
    }

    public String getAuthor() {
        return this.author;
    }

    public int[] getPixels() {
        return this.pixels;
    }

    public int getWidth() {
        return this.size.width;
    }

    public int getHeight() {
        return this.size.height;
    }

    public int getPixelWidth() {
        return this.size.pixelWidth;
    }

    public int getPixelHeight() {
        return this.size.pixelHeight;
    }

    public int[] copyPixels() {
        int[] copiedPixels = new int[this.pixels.length];
        for (int i = 0; i < this.pixels.length; ++i) {
            copiedPixels[i] = this.pixels[i];
        }
        return copiedPixels;
    }

    public String toString() {
        return this.name;
    }

    public void writeToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74778_a("Name", this.getName());
        tagCompound.func_74778_a("Author", this.getAuthor());
        tagCompound.func_74783_a("Pixels", this.pixels);
        tagCompound.func_74768_a("Resolution", this.size.width);
    }

    public static Picture fromFile(File file) {
        NBTTagCompound data = file.getData();
        Picture picture = new Picture(data.func_74779_i("Name"), data.func_74779_i("Author"), Size.getFromSize(data.func_74762_e("Resolution")));
        picture.source = file;
        picture.pixels = data.func_74759_k("Pixels");
        return picture;
    }

    public static enum Size {
        X16(16, 16, 8, 8),
        X32(32, 32, 4, 4);

        public int width;
        public int height;
        public int pixelWidth;
        public int pixelHeight;

        private Size(int width, int height, int pixelWidth, int pixelHeight) {
            this.width = width;
            this.height = height;
            this.pixelWidth = pixelWidth;
            this.pixelHeight = pixelHeight;
        }

        public static Size getFromSize(int size) {
            if (size == 16) {
                return X16;
            }
            if (size == 32) {
                return X32;
            }
            return null;
        }
    }
}

