/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.programs.email;

import com.google.common.collect.HashBiMap;
import com.mrcrayfish.device.api.app.Icons;
import com.mrcrayfish.device.api.app.Notification;
import com.mrcrayfish.device.programs.email.object.Email;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EmailManager {
    public static final EmailManager INSTANCE = new EmailManager();
    @SideOnly(value=Side.CLIENT)
    private List<Email> inbox;
    private HashBiMap<UUID, String> uuidToName = HashBiMap.create();
    private Map<String, List<Email>> nameToInbox = new HashMap<String, List<Email>>();

    public boolean addEmailToInbox(Email email, String to) {
        if (this.nameToInbox.containsKey(to)) {
            this.nameToInbox.get(to).add(0, email);
            this.sendNotification(to, email);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public List<Email> getInbox() {
        if (this.inbox == null) {
            this.inbox = new ArrayList<Email>();
        }
        return this.inbox;
    }

    public List<Email> getEmailsForAccount(EntityPlayer player) {
        if (this.uuidToName.containsKey((Object)player.func_110124_au())) {
            return this.nameToInbox.get(this.uuidToName.get((Object)player.func_110124_au()));
        }
        return new ArrayList<Email>();
    }

    public boolean addAccount(EntityPlayer player, String name) {
        if (!this.uuidToName.containsKey((Object)player.func_110124_au()) && !this.uuidToName.containsValue((Object)name)) {
            this.uuidToName.put((Object)player.func_110124_au(), (Object)name);
            this.nameToInbox.put(name, new ArrayList());
            return true;
        }
        return false;
    }

    public boolean hasAccount(UUID uuid) {
        return this.uuidToName.containsKey((Object)uuid);
    }

    public String getName(EntityPlayer player) {
        return (String)this.uuidToName.get((Object)player.func_110124_au());
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.nameToInbox.clear();
        NBTTagList inboxes = (NBTTagList)nbt.func_74781_a("Inboxes");
        for (int i = 0; i < inboxes.func_74745_c(); ++i) {
            NBTTagCompound inbox = inboxes.func_150305_b(i);
            String name = inbox.func_74779_i("Name");
            ArrayList<Email> emails = new ArrayList<Email>();
            NBTTagList emailTagList = (NBTTagList)inbox.func_74781_a("Emails");
            for (int j = 0; j < emailTagList.func_74745_c(); ++j) {
                NBTTagCompound emailTag = emailTagList.func_150305_b(j);
                Email email = Email.readFromNBT(emailTag);
                emails.add(email);
            }
            this.nameToInbox.put(name, emails);
        }
        this.uuidToName.clear();
        NBTTagList accounts = (NBTTagList)nbt.func_74781_a("Accounts");
        for (int i = 0; i < accounts.func_74745_c(); ++i) {
            NBTTagCompound account = accounts.func_150305_b(i);
            UUID uuid = UUID.fromString(account.func_74779_i("UUID"));
            String name = account.func_74779_i("Name");
            this.uuidToName.put((Object)uuid, (Object)name);
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList inboxes = new NBTTagList();
        for (String key : this.nameToInbox.keySet()) {
            NBTTagCompound inbox = new NBTTagCompound();
            inbox.func_74778_a("Name", key);
            NBTTagList emailTagList = new NBTTagList();
            List<Email> emails = this.nameToInbox.get(key);
            for (Email email : emails) {
                NBTTagCompound emailTag = new NBTTagCompound();
                email.writeToNBT(emailTag);
                emailTagList.func_74742_a((NBTBase)emailTag);
            }
            inbox.func_74782_a("Emails", (NBTBase)emailTagList);
            inboxes.func_74742_a((NBTBase)inbox);
        }
        nbt.func_74782_a("Inboxes", (NBTBase)inboxes);
        NBTTagList accounts = new NBTTagList();
        for (UUID key : this.uuidToName.keySet()) {
            NBTTagCompound account = new NBTTagCompound();
            account.func_74778_a("UUID", key.toString());
            account.func_74778_a("Name", (String)this.uuidToName.get((Object)key));
            accounts.func_74742_a((NBTBase)account);
        }
        nbt.func_74782_a("Accounts", (NBTBase)accounts);
    }

    public void clear() {
        this.nameToInbox.clear();
        this.uuidToName.clear();
        this.inbox.clear();
    }

    private void sendNotification(String name, Email email) {
        EntityPlayerMP player;
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        UUID id = (UUID)this.uuidToName.inverse().get((Object)name);
        if (id != null && (player = server.func_184103_al().func_177451_a(id)) != null) {
            Notification notification = new Notification(Icons.MAIL, "New Email!", "from " + email.getAuthor());
            notification.pushTo(player);
        }
    }
}

