/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.programs.example;

import com.mrcrayfish.device.api.app.Application;
import com.mrcrayfish.device.api.app.Icons;
import com.mrcrayfish.device.api.app.component.Button;
import com.mrcrayfish.device.api.app.component.CheckBox;
import com.mrcrayfish.device.api.app.component.Image;
import com.mrcrayfish.device.api.app.component.ItemList;
import com.mrcrayfish.device.api.app.component.Label;
import com.mrcrayfish.device.api.app.component.ProgressBar;
import com.mrcrayfish.device.api.app.component.Slider;
import com.mrcrayfish.device.api.app.component.Spinner;
import com.mrcrayfish.device.api.app.component.Text;
import com.mrcrayfish.device.api.app.component.TextArea;
import com.mrcrayfish.device.api.app.component.TextField;
import com.mrcrayfish.device.api.app.listener.SlideListener;
import com.mrcrayfish.device.api.task.TaskManager;
import com.mrcrayfish.device.programs.example.task.TaskNotificationTest;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;

public class ApplicationExample
extends Application {
    private Label label;
    private Button button;
    private Button leftButton;
    private Button upButton;
    private Button rightButton;
    private Button downButton;
    private ItemList<String> itemList;
    private CheckBox checkBoxOn;
    private CheckBox checkBoxOff;
    private ProgressBar progressBar;
    private Slider slider;
    private Spinner spinner;
    private TextField textField;
    private TextArea textArea;
    private Text text;
    private Image image;

    public ApplicationExample() {
        this.setDefaultWidth(270);
        this.setDefaultHeight(140);
    }

    @Override
    public void init(@Nullable NBTTagCompound intent) {
        this.label = new Label("Label", 5, 5);
        super.addComponent(this.label);
        this.button = new Button(5, 18, "Button");
        this.button.setSize(63, 20);
        this.button.setClickListener((mouseX, mouseY, mouseButton) -> this.itemList.addItem("Henlo"));
        super.addComponent(this.button);
        this.leftButton = new Button(5, 43, Icons.CHEVRON_LEFT);
        this.leftButton.setPadding(1);
        this.leftButton.setClickListener((mouseX, mouseY, mouseButton) -> this.itemList.removeItem(this.itemList.getSelectedIndex()));
        super.addComponent(this.leftButton);
        this.upButton = new Button(22, 43, Icons.CHEVRON_UP);
        this.upButton.setPadding(1);
        super.addComponent(this.upButton);
        this.rightButton = new Button(39, 43, Icons.CHEVRON_RIGHT);
        this.rightButton.setPadding(1);
        super.addComponent(this.rightButton);
        this.downButton = new Button(56, 43, Icons.CHEVRON_DOWN);
        this.downButton.setPadding(1);
        this.downButton.setClickListener((mouseX, mouseY, mouseButton) -> TaskManager.sendTask(new TaskNotificationTest()));
        super.addComponent(this.downButton);
        this.itemList = new ItemList(5, 60, 63, 4);
        this.itemList.addItem("Item #1");
        this.itemList.addItem("Item #2");
        this.itemList.addItem("Item #3");
        super.addComponent(this.itemList);
        this.checkBoxOff = new CheckBox("Off", 5, 122);
        super.addComponent(this.checkBoxOff);
        this.checkBoxOn = new CheckBox("On", 42, 122);
        this.checkBoxOn.setSelected(true);
        super.addComponent(this.checkBoxOn);
        this.textField = new TextField(88, 5, 80);
        this.textField.setPlaceholder("Text Field");
        this.textField.setIcon(Icons.USER);
        super.addComponent(this.textField);
        this.textArea = new TextArea(88, 25, 80, 60);
        this.textArea.setPlaceholder("Text Area");
        super.addComponent(this.textArea);
        this.progressBar = new ProgressBar(88, 90, 80, 16);
        this.progressBar.setProgress(75);
        super.addComponent(this.progressBar);
        this.slider = new Slider(88, 111, 80);
        this.slider.setSlideListener(new SlideListener(){

            @Override
            public void onSlide(float percentage) {
                ApplicationExample.this.progressBar.setProgress((int)(100.0f * percentage));
            }
        });
        super.addComponent(this.slider);
        this.spinner = new Spinner(56, 3);
        super.addComponent(this.spinner);
        this.text = new Text("", 180, 5, 90);
        this.text.setText("Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.");
        super.addComponent(this.text);
        this.image = new Image(180, 100, 85, 35, "https://minecraft.net/static/pages/img/minecraft-hero-og.c5517b7973e1.jpg");
        this.image.setAlpha(0.8f);
        super.addComponent(this.image);
    }

    @Override
    public void load(NBTTagCompound tagCompound) {
    }

    @Override
    public void save(NBTTagCompound tagCompound) {
    }
}

