/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.util.RewardBlockCache;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class TicTacToeReward
extends BaseCustomReward {
    public TicTacToeReward() {
        super("chancecubes:tic_tac_toe", 0);
    }

    @Override
    public void trigger(final World world, final BlockPos pos, final EntityPlayer player, Map<String, Object> settings) {
        player.func_145747_a((ITextComponent)new TextComponentString("Lets play Tic-Tac-Toe!"));
        player.func_145747_a((ITextComponent)new TextComponentString("Beat the Computer to get 500 Diamonds!"));
        player.field_70170_p.func_72838_d((Entity)new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, new ItemStack(Blocks.field_150325_L, 5, 14)));
        final RewardBlockCache cache = new RewardBlockCache(world, pos, player.func_180425_c());
        for (int x = -2; x < 3; ++x) {
            for (int z = -1; z < 2; ++z) {
                for (int y = 0; y < 5; ++y) {
                    cache.cacheBlock(new BlockPos(x, y, z), Blocks.field_150350_a.func_176223_P());
                }
            }
        }
        world.func_175656_a(pos.func_177982_a(-1, 0, 0), Blocks.field_150357_h.func_176223_P());
        world.func_175656_a(pos.func_177982_a(-1, 1, 0), Blocks.field_150357_h.func_176223_P());
        world.func_175656_a(pos.func_177982_a(-1, 2, 0), Blocks.field_150357_h.func_176223_P());
        world.func_175656_a(pos.func_177982_a(-1, 3, 0), Blocks.field_150357_h.func_176223_P());
        world.func_175656_a(pos.func_177982_a(-1, 4, 0), Blocks.field_150357_h.func_176223_P());
        world.func_175656_a(pos.func_177982_a(1, 0, 0), Blocks.field_150357_h.func_176223_P());
        world.func_175656_a(pos.func_177982_a(1, 1, 0), Blocks.field_150357_h.func_176223_P());
        world.func_175656_a(pos.func_177982_a(1, 2, 0), Blocks.field_150357_h.func_176223_P());
        world.func_175656_a(pos.func_177982_a(1, 3, 0), Blocks.field_150357_h.func_176223_P());
        world.func_175656_a(pos.func_177982_a(1, 4, 0), Blocks.field_150357_h.func_176223_P());
        world.func_175656_a(pos.func_177982_a(-2, 1, 0), Blocks.field_150357_h.func_176223_P());
        world.func_175656_a(pos.func_177982_a(0, 1, 0), Blocks.field_150357_h.func_176223_P());
        world.func_175656_a(pos.func_177982_a(2, 1, 0), Blocks.field_150357_h.func_176223_P());
        world.func_175656_a(pos.func_177982_a(-2, 3, 0), Blocks.field_150357_h.func_176223_P());
        world.func_175656_a(pos.func_177982_a(0, 3, 0), Blocks.field_150357_h.func_176223_P());
        world.func_175656_a(pos.func_177982_a(2, 3, 0), Blocks.field_150357_h.func_176223_P());
        Scheduler.scheduleTask(new Task("Tic_Tac_Toe_Game", 6000, 5){
            Board board;
            {
                super(name, delay, updateTick);
                this.board = new Board();
            }

            @Override
            public void callback() {
                cache.restoreBlocks((Entity)player);
            }

            @Override
            public void update() {
                for (int x = -1; x < 2; ++x) {
                    for (int y = -1; y < 2; ++y) {
                        if (this.board.board[x + 1][y + 1] != 0 || world.func_175623_d(pos.func_177982_a(x * 2, y * 2 + 2, 0))) continue;
                        this.makeMove(x + 1, y + 1);
                    }
                }
            }

            private void makeMove(int x, int y) {
                this.board.placeMove(x, y, 2);
                if (!this.board.isGameOver()) {
                    this.board.minimax(0, 1);
                    this.board.placeMove(this.board.computersMove.x, this.board.computersMove.y, 1);
                    world.func_175656_a(pos.func_177982_a(this.board.computersMove.x * 2 - 2, this.board.computersMove.y * 2, 0), RewardsUtil.getBlockStateFromBlockMeta(Blocks.field_150325_L, 11));
                }
                if (this.board.isGameOver()) {
                    if (this.board.hasCPUWon()) {
                        player.func_145747_a((ITextComponent)new TextComponentString("The Computer won! Better luck next time!"));
                    } else if (this.board.hasPlayerWon()) {
                        player.field_70170_p.func_72838_d((Entity)new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, new ItemStack(Items.field_151045_i, 500)));
                    } else {
                        player.func_145747_a((ITextComponent)new TextComponentString("You tied! Better luck next time!"));
                    }
                    final 1 superTask = this;
                    Scheduler.scheduleTask(new Task("Tic_Tac_Toe_Game_End_Delay", 40){

                        @Override
                        public void callback() {
                            superTask.delayLeft = 0;
                        }
                    });
                }
            }
        });
    }

    private static class Board {
        public int[][] board = new int[3][3];
        public Point computersMove;

        private Board() {
        }

        public boolean isGameOver() {
            return this.hasPlayerWon() || this.hasCPUWon() || this.getAvailableStates().isEmpty();
        }

        public boolean hasCPUWon() {
            if (this.board[0][0] == this.board[1][1] && this.board[0][0] == this.board[2][2] && this.board[0][0] == 1 || this.board[0][2] == this.board[1][1] && this.board[0][2] == this.board[2][0] && this.board[0][2] == 1) {
                return true;
            }
            for (int i = 0; i < 3; ++i) {
                if ((this.board[i][0] != this.board[i][1] || this.board[i][0] != this.board[i][2] || this.board[i][0] != 1) && (this.board[0][i] != this.board[1][i] || this.board[0][i] != this.board[2][i] || this.board[0][i] != 1)) continue;
                return true;
            }
            return false;
        }

        public boolean hasPlayerWon() {
            if (this.board[0][0] == this.board[1][1] && this.board[0][0] == this.board[2][2] && this.board[0][0] == 2 || this.board[0][2] == this.board[1][1] && this.board[0][2] == this.board[2][0] && this.board[0][2] == 2) {
                return true;
            }
            for (int i = 0; i < 3; ++i) {
                if ((this.board[i][0] != this.board[i][1] || this.board[i][0] != this.board[i][2] || this.board[i][0] != 2) && (this.board[0][i] != this.board[1][i] || this.board[0][i] != this.board[2][i] || this.board[0][i] != 2)) continue;
                return true;
            }
            return false;
        }

        public List<Point> getAvailableStates() {
            ArrayList<Point> availablePoints = new ArrayList<Point>();
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    if (this.board[i][j] != 0) continue;
                    availablePoints.add(new Point(i, j));
                }
            }
            return availablePoints;
        }

        public void placeMove(int x, int y, int player) {
            this.board[x][y] = player;
        }

        public int minimax(int depth, int turn) {
            if (this.hasCPUWon()) {
                return 1;
            }
            if (this.hasPlayerWon()) {
                return -1;
            }
            List<Point> pointsAvailable = this.getAvailableStates();
            if (pointsAvailable.isEmpty()) {
                return 0;
            }
            int min = Integer.MAX_VALUE;
            int max = Integer.MIN_VALUE;
            for (int i = 0; i < pointsAvailable.size(); ++i) {
                int currentScore;
                Point point = pointsAvailable.get(i);
                if (turn == 1) {
                    this.placeMove(point.x, point.y, 1);
                    currentScore = this.minimax(depth + 1, 2);
                    max = Math.max(currentScore, max);
                    if (currentScore >= 0 && depth == 0) {
                        this.computersMove = point;
                    }
                    if (currentScore == 1) {
                        this.board[point.x][point.y] = 0;
                        break;
                    }
                    if (i == pointsAvailable.size() - 1 && max < 0 && depth == 0) {
                        this.computersMove = point;
                    }
                } else if (turn == 2) {
                    this.placeMove(point.x, point.y, 2);
                    currentScore = this.minimax(depth + 1, 1);
                    min = Math.min(currentScore, min);
                    if (min == -1) {
                        this.board[point.x][point.y] = 0;
                        break;
                    }
                }
                this.board[point.x][point.y] = 0;
            }
            return turn == 1 ? max : min;
        }
    }

    private static class Point {
        int x;
        int y;

        public Point(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

