/*
 * Decompiled with CFR 0.152.
 */
package superhb.arcademod.util.prizebox;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;

public class PrizeHelper {
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public static ItemStack getItemStack(JsonObject object) {
        String resourceName = JsonUtils.func_151200_h((JsonObject)object, (String)"item");
        Item item = Item.func_111206_d((String)resourceName);
        if (item == null) {
            throw new JsonSyntaxException(String.format("Unknown item '%s'", resourceName));
        }
        if (item.func_77614_k() && !object.has("data")) {
            throw new JsonParseException(String.format("Missing metadata for item '%s'", resourceName));
        }
        if (object.has("nbt")) {
            try {
                JsonElement element = object.get("nbt");
                NBTTagCompound nbt = element.isJsonObject() ? JsonToNBT.func_180713_a((String)GSON.toJson(element)) : JsonToNBT.func_180713_a((String)element.getAsString());
                NBTTagCompound tmp = new NBTTagCompound();
                tmp.func_74782_a("tag", (NBTBase)nbt);
                tmp.func_74778_a("id", resourceName);
                tmp.func_74768_a("Count", 1);
                tmp.func_74768_a("Damage", JsonUtils.func_151208_a((JsonObject)object, (String)"data", (int)0));
                return new ItemStack(tmp);
            }
            catch (NBTException e) {
                throw new JsonSyntaxException("Invalid NBT Entry: " + e.toString());
            }
        }
        return new ItemStack(item, 1, JsonUtils.func_151208_a((JsonObject)object, (String)"data", (int)0));
    }
}

