/*
 * Decompiled with CFR 0.152.
 */
package com.alobin90.kfc.world.generators;

import com.alobin90.kfc.world.generators.WorldGenStructure;
import com.alobin90.kfc.world.generators.WorldGenStructure2;
import com.alobin90.kfc.world.generators.WorldGenStructure3;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeForest;
import net.minecraft.world.biome.BiomePlains;
import net.minecraft.world.biome.BiomeSavanna;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenCustomStructure
implements IWorldGenerator {
    int lastX = 0;
    int lastZ = 0;
    public static final WorldGenStructure KFC_BUILDING = new WorldGenStructure("mb");
    public static final WorldGenStructure2 BB = new WorldGenStructure2("bb");
    public static final WorldGenStructure3 SB = new WorldGenStructure3("sb");

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case 2: {
                break;
            }
            case 1: {
                break;
            }
            case 0: {
                this.generateStructure(KFC_BUILDING, world, random, chunkX, chunkZ, 100, (Block)Blocks.field_150349_c, BiomePlains.class);
                this.generateStructure(BB, world, random, chunkX, chunkZ, 1000, (Block)Blocks.field_150349_c, BiomeForest.class);
                this.generateStructure(SB, world, random, chunkX, chunkZ, 1000, (Block)Blocks.field_150349_c, BiomeSavanna.class);
            }
        }
    }

    private void generateStructure(WorldGenerator generator, World world, Random random, int chunkX, int chunkZ, int chance, Block topBlock, Class<?> ... classes) {
        ArrayList classesList = new ArrayList(Arrays.asList(classes));
        int x = chunkX * 16 + random.nextInt(16);
        int z = chunkZ * 16 + random.nextInt(16);
        int y = WorldGenCustomStructure.calculateGenerationHeight(world, x, z, topBlock);
        BlockPos pos = new BlockPos(x, y, z);
        Class<?> biome = world.field_73011_w.getBiomeForCoords(pos).getClass();
        if (world.func_175624_G() != WorldType.field_77138_c && classesList.contains(biome) && random.nextInt(chance) == 0) {
            double distance = Math.pow(Math.pow(this.lastX - x, 2.0) + Math.pow(this.lastZ - z, 2.0), 0.5);
            System.out.println(x);
            System.out.println(z);
            System.out.println(distance);
            if (this.lastX == 0 || distance > 1000.0) {
                generator.func_180709_b(world, random, pos);
                this.lastX = x;
                this.lastZ = z;
            }
        }
    }

    private static int calculateGenerationHeight(World world, int x, int z, Block topBlock) {
        int y = world.func_72800_K();
        boolean foundGround = false;
        while (!foundGround && y-- >= 64) {
            Block block = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
            foundGround = block == topBlock;
        }
        return y;
    }
}

