/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.client;

import com.google.common.primitives.Longs;
import com.mrcrayfish.furniture.client.ImageCache;
import java.io.IOException;
import java.net.URI;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.IOUtils;

public class ImageDownloadThread
extends Thread {
    private static final String[] SUPPORTED_FILE_TYPES = new String[]{"png", "jpeg", "jpg"};
    private static final String[] SUPPORTED_CONTENT_TYPES = new String[]{"image/png", "image/jpeg"};
    private static final Set<String> LOADING_URLS = new HashSet<String>();
    private static final long MAX_FILE_SIZE = 0x200000L;
    private URI uri;
    private ResponseProcessor processor;
    private int tryCount;

    public ImageDownloadThread(URI uri, ResponseProcessor processor) {
        super("Image Download Thread");
        this.uri = uri;
        this.processor = processor;
    }

    @Override
    public void run() {
        String url = this.uri.toString();
        if (ImageCache.INSTANCE.loadCached(url)) {
            this.processor.process(ImageDownloadResult.SUCCESS, "Successfully processed image");
            return;
        }
        if (ImageDownloadThread.isLoading(url)) {
            do {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (!ImageCache.INSTANCE.isCached(url)) continue;
                this.processor.process(ImageDownloadResult.SUCCESS, "Successfully processed image");
                return;
            } while (this.tryCount++ != 10);
            this.processor.process(ImageDownloadResult.FAILED, "Unable to process image");
            return;
        }
        try {
            URLConnection connection = this.uri.toURL().openConnection();
            connection.addRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)");
            boolean failed = true;
            for (String format : SUPPORTED_CONTENT_TYPES) {
                if (!format.equals(connection.getContentType())) continue;
                failed = false;
                break;
            }
            if (failed) {
                this.processor.process(ImageDownloadResult.UNKNOWN_FILE, "The file is not a image");
                return;
            }
            String lengthString = connection.getHeaderField("Content-Length");
            if (lengthString == null) {
                this.processor.process(ImageDownloadResult.UNKNOWN_SIZE, "Unable to determine size of image");
                return;
            }
            Long length = Longs.tryParse((String)lengthString);
            if (length == null) {
                this.processor.process(ImageDownloadResult.UNKNOWN_SIZE, "Unable to determine size of GIF image");
                return;
            }
            if (length > 0x200000L) {
                this.processor.process(ImageDownloadResult.TOO_LARGE, "The image is greater than 2048.0MB");
                return;
            }
            ImageDownloadThread.setLoading(url, true);
            byte[] data = IOUtils.toByteArray((URLConnection)connection);
            if (ImageCache.INSTANCE.add(url, data)) {
                ImageDownloadThread.setLoading(url, false);
                this.processor.process(ImageDownloadResult.SUCCESS, "Successfully processed image");
                return;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.processor.process(ImageDownloadResult.FAILED, "Unable to process image");
        ImageDownloadThread.setLoading(url, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLoading(String url, boolean loading) {
        Set<String> set = LOADING_URLS;
        synchronized (set) {
            if (loading) {
                LOADING_URLS.add(url);
            } else {
                LOADING_URLS.remove(url);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLoading(String url) {
        Set<String> set = LOADING_URLS;
        synchronized (set) {
            return LOADING_URLS.contains(url);
        }
    }

    public static enum ImageDownloadResult {
        SUCCESS("cfm.photo_frame.success"),
        FAILED("cfm.photo_frame.failed"),
        UNKNOWN_FILE("cfm.photo_frame.unknown_file"),
        TOO_LARGE("cfm.photo_frame.too_large"),
        UNTRUSTED("cfm.photo_frame.untrusted"),
        INVALID_URL("cfm.photo_frame.invalid"),
        WRONG_SCHEME("cfm.photo_frame.wrong_scheme"),
        UNSUPPORTED_FILE_TYPE("cfm.photo_frame.unsupported_type"),
        UNKNOWN_SIZE("cfm.photo_frame.unknown_size");

        private String key;

        private ImageDownloadResult(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }

    public static interface ResponseProcessor {
        public void process(ImageDownloadResult var1, String var2);
    }
}

