/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.drop;

import java.util.ArrayList;
import java.util.Random;
import mod.lucky.drop.value.ValueParser;

public class LuckyDropRaw {
    private String rawDrop;
    private int luck = 2;
    private float chance = 1.0f;
    private final Random random;

    public LuckyDropRaw(String rawDrop) {
        if (rawDrop.startsWith("(") && rawDrop.endsWith(")") || rawDrop.startsWith("[") && rawDrop.endsWith("]") || rawDrop.startsWith("{") && rawDrop.endsWith("}")) {
            rawDrop = rawDrop.substring(1, rawDrop.length() - 1);
        }
        this.rawDrop = rawDrop;
        this.random = new Random();
        try {
            this.getDropProperties();
        }
        catch (Exception e) {
            System.out.println("The Lucky Block encountered and error while loading properties for drop: " + rawDrop);
            e.printStackTrace();
        }
    }

    public LuckyDropRaw() {
        this.random = new Random();
    }

    public void getDropProperties() {
        ArrayList<Integer> points = new ArrayList<Integer>();
        int count = 0;
        while (true) {
            int propertyStringLength;
            boolean propertyType;
            int luckPoint;
            int chancePoint;
            if ((chancePoint = this.rawDrop.indexOf("@chance=")) < (luckPoint = this.rawDrop.indexOf("@luck=")) && chancePoint != -1 || luckPoint == -1 && chancePoint > -1) {
                propertyType = false;
                propertyStringLength = "@chance=".length();
                points.add(count, chancePoint);
            } else {
                if ((luckPoint >= chancePoint || luckPoint == -1) && (chancePoint != -1 || luckPoint <= -1)) break;
                propertyType = true;
                propertyStringLength = "@luck=".length();
                points.add(count, luckPoint);
            }
            char[] invalidChars = new char[]{'+', '*', '(', ')', ',', ';', '/', '@'};
            int currEndPoint = LuckyDropRaw.getEndPoint(this.rawDrop, (Integer)points.get(count) + propertyStringLength, invalidChars);
            String currValue = this.rawDrop.substring((Integer)points.get(count) + propertyStringLength, currEndPoint);
            if (currValue.startsWith("(") && currValue.endsWith(")")) {
                currValue = currValue.substring(1, currValue.length() - 1);
            }
            if (!propertyType) {
                this.chance = ValueParser.getFloat(currValue).floatValue();
            }
            if (propertyType) {
                this.luck = ValueParser.getInteger(currValue);
            }
            String linePart1 = this.rawDrop.substring(0, (Integer)points.get(count));
            String linePart2 = this.rawDrop.substring(currEndPoint, this.rawDrop.length());
            this.rawDrop = linePart1 + linePart2;
            ++count;
        }
    }

    public LuckyDropRaw copy() {
        LuckyDropRaw luckyDropBase = new LuckyDropRaw("");
        luckyDropBase.rawDrop = this.rawDrop;
        luckyDropBase.luck = this.luck;
        luckyDropBase.chance = this.chance;
        return luckyDropBase;
    }

    public String getDropValue() {
        return this.rawDrop;
    }

    public void setDropValue(String dropValue) {
        this.rawDrop = dropValue;
    }

    public int getLuck() {
        return this.luck;
    }

    public void setLuck(int luck) {
        this.luck = luck;
    }

    public float getChance() {
        return this.chance;
    }

    public void setChance(float chance) {
        this.chance = chance;
    }

    public String toString() {
        return this.rawDrop;
    }

    private static int getEndPoint(String value, int startPoint, char ... invalidChars) {
        char[] chars = value.toCharArray();
        int endPoint = chars.length;
        for (int i = startPoint; i < chars.length; ++i) {
            boolean shouldBreak = false;
            for (char invalidChar : invalidChars) {
                if (chars[i] != invalidChar) continue;
                endPoint = i;
                shouldBreak = true;
                break;
            }
            if (shouldBreak) break;
        }
        return endPoint;
    }
}

