/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.structure;

import java.io.DataInputStream;
import java.util.zip.GZIPInputStream;
import mod.lucky.drop.DropProperties;
import mod.lucky.drop.func.DropProcessData;
import mod.lucky.structure.BlockPlacer;
import mod.lucky.structure.Structure;
import mod.lucky.structure.StructureUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class SchematicStructure
extends Structure {
    private Block[][][] blocks;
    private int[][][] blockData;
    private NBTTagCompound[] entities;
    private NBTTagCompound[] tileEntities;

    @Override
    public void process(DropProcessData processData) {
        DropProperties drop = processData.getDropProperties();
        Vec3d harvestPos = drop.getVecPos();
        int rotation = drop.getPropertyInt("rotation");
        BlockPlacer blockPlacer = new BlockPlacer(processData.getWorld());
        for (int y = 0; y < this.height; ++y) {
            for (int z = 0; z < this.width; ++z) {
                for (int x = 0; x < this.length; ++x) {
                    if (this.blockMode.equals("overlay")) {
                        if (this.blocks[y][z][x] == Blocks.field_150350_a) continue;
                        StructureUtils.setBlock(blockPlacer, this.blocks[y][z][x].func_176203_a(this.blockData[y][z][x]), new BlockPos(x, y, z), this.getCenterPos(), harvestPos, rotation);
                        continue;
                    }
                    if (this.blockMode.equals("air")) {
                        if (this.blocks[y][z][x] == Blocks.field_150350_a) continue;
                        StructureUtils.setBlock(blockPlacer, Blocks.field_150350_a.func_176223_P(), new BlockPos(x, y, z), this.getCenterPos(), harvestPos, rotation);
                        continue;
                    }
                    StructureUtils.setBlock(blockPlacer, this.blocks[y][z][x].func_176203_a(this.blockData[y][z][x]), new BlockPos(x, y, z), this.getCenterPos(), harvestPos, rotation);
                }
            }
        }
        for (NBTTagCompound tileEntity : this.tileEntities) {
            StructureUtils.setTileEntity(processData.getWorld(), TileEntity.func_190200_a((World)processData.getWorld(), (NBTTagCompound)tileEntity), this.getCenterPos(), harvestPos, rotation);
        }
        for (NBTTagCompound entity : this.entities) {
            StructureUtils.setEntity(processData.getWorld(), EntityList.func_75615_a((NBTTagCompound)entity, (World)processData.getWorld()), this.getCenterPos(), harvestPos, rotation);
        }
        if (this.blockUpdate) {
            blockPlacer.update();
        }
        this.processOverlay(processData);
    }

    @Override
    public void readFromFile() {
        NBTTagCompound nbtTagCompound = null;
        try {
            DataInputStream dataInputStream = new DataInputStream(new GZIPInputStream(this.fileStream));
            nbtTagCompound = CompressedStreamTools.func_74794_a((DataInputStream)dataInputStream);
            dataInputStream.close();
        }
        catch (Exception e) {
            System.err.println("Lucky Block: Error loading structure '" + this.getId() + "'");
            e.printStackTrace();
        }
        this.length = nbtTagCompound.func_74765_d("Width");
        this.width = nbtTagCompound.func_74765_d("Length");
        this.height = nbtTagCompound.func_74765_d("Height");
        int size = this.length * this.width * this.height;
        if (size > 100000) {
            System.err.println("Lucky Block: Error loading structure. The structure '" + this.getId() + "' (" + size + " blocks) exceeds the " + 100000 + " block limit");
            return;
        }
        this.blocks = new Block[this.height][this.width][this.length];
        this.blockData = new int[this.height][this.width][this.length];
        byte[] blockIdsByte = nbtTagCompound.func_74770_j("Blocks");
        byte[] blockDataByte = nbtTagCompound.func_74770_j("Data");
        int x = 1;
        int y = 1;
        int z = 1;
        for (int i = 0; i < blockIdsByte.length; ++i) {
            short blockId = (short)(blockIdsByte[i] & 0xFF);
            this.blocks[y - 1][z - 1][x - 1] = Block.func_149729_e((int)blockId);
            this.blockData[y - 1][z - 1][x - 1] = blockDataByte[i];
            if (++x > this.length) {
                x = 1;
                ++z;
            }
            if (z <= this.width) continue;
            z = 1;
            ++y;
        }
        NBTTagList entityList = nbtTagCompound.func_150295_c("Entities", 10);
        this.entities = new NBTTagCompound[entityList.func_74745_c()];
        for (int i = 0; i < entityList.func_74745_c(); ++i) {
            this.entities[i] = entityList.func_150305_b(i);
        }
        NBTTagList tileEntityList = nbtTagCompound.func_150295_c("TileEntities", 10);
        this.tileEntities = new NBTTagCompound[tileEntityList.func_74745_c()];
        for (int i = 0; i < tileEntityList.func_74745_c(); ++i) {
            this.tileEntities[i] = tileEntityList.func_150305_b(i);
        }
        this.initCenterPos();
    }
}

