/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import javax.print.DocFlavor;
import javax.print.MultiDocPrintService;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.PrintRequestAttribute;
import javax.print.attribute.PrintServiceAttribute;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.PrinterName;
import sun.print.Win32PrintService;
import sun.security.action.GetPropertyAction;

public class PrintServiceLookupProvider
extends PrintServiceLookup {
    private String defaultPrinter;
    private PrintService defaultPrintService;
    private String[] printers;
    private PrintService[] printServices;
    private static boolean pollServices;
    private static final int DEFAULT_MINREFRESH = 240;
    private static int minRefreshTime;
    private static PrintServiceLookupProvider win32PrintLUS;

    public static PrintServiceLookupProvider getWin32PrintLUS() {
        if (win32PrintLUS == null) {
            PrintServiceLookup.lookupDefaultPrintService();
        }
        return win32PrintLUS;
    }

    public PrintServiceLookupProvider() {
        if (win32PrintLUS == null) {
            win32PrintLUS = this;
            String string = AccessController.doPrivileged(new GetPropertyAction("os.name"));
            if (string != null && string.startsWith("Windows 98")) {
                return;
            }
            PrinterChangeListener printerChangeListener = new PrinterChangeListener();
            printerChangeListener.setDaemon(true);
            printerChangeListener.start();
            if (pollServices) {
                RemotePrinterChangeListener remotePrinterChangeListener = new RemotePrinterChangeListener();
                remotePrinterChangeListener.setDaemon(true);
                remotePrinterChangeListener.start();
            }
        }
    }

    @Override
    public synchronized PrintService[] getPrintServices() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        if (this.printServices == null) {
            this.refreshServices();
        }
        return this.printServices;
    }

    private synchronized void refreshServices() {
        int n;
        this.printers = this.getAllPrinterNames();
        if (this.printers == null) {
            this.printServices = new PrintService[0];
            return;
        }
        PrintService[] printServiceArray = new PrintService[this.printers.length];
        PrintService printService = this.getDefaultPrintService();
        for (n = 0; n < this.printers.length; ++n) {
            int n2;
            if (printService != null && this.printers[n].equals(printService.getName())) {
                printServiceArray[n] = printService;
                continue;
            }
            if (this.printServices == null) {
                printServiceArray[n] = new Win32PrintService(this.printers[n]);
                continue;
            }
            for (n2 = 0; n2 < this.printServices.length; ++n2) {
                if (this.printServices[n2] == null || !this.printers[n].equals(this.printServices[n2].getName())) continue;
                printServiceArray[n] = this.printServices[n2];
                this.printServices[n2] = null;
                break;
            }
            if (n2 != this.printServices.length) continue;
            printServiceArray[n] = new Win32PrintService(this.printers[n]);
        }
        if (this.printServices != null) {
            for (n = 0; n < this.printServices.length; ++n) {
                if (!(this.printServices[n] instanceof Win32PrintService) || this.printServices[n].equals(this.defaultPrintService)) continue;
                ((Win32PrintService)this.printServices[n]).invalidateService();
            }
        }
        this.printServices = printServiceArray;
    }

    public synchronized PrintService getPrintServiceByName(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        PrintService[] printServiceArray = this.getPrintServices();
        for (int i = 0; i < printServiceArray.length; ++i) {
            if (!printServiceArray[i].getName().equals(string)) continue;
            return printServiceArray[i];
        }
        return null;
    }

    boolean matchingService(PrintService printService, PrintServiceAttributeSet printServiceAttributeSet) {
        if (printServiceAttributeSet != null) {
            Attribute[] attributeArray = printServiceAttributeSet.toArray();
            for (int i = 0; i < attributeArray.length; ++i) {
                Attribute attribute = printService.getAttribute(attributeArray[i].getCategory());
                if (attribute != null && attribute.equals(attributeArray[i])) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public PrintService[] getPrintServices(DocFlavor docFlavor, AttributeSet attributeSet) {
        PrinterName printerName;
        PrintService printService;
        Object[] objectArray;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = null;
        AttributeSet attributeSet2 = null;
        if (attributeSet != null && !attributeSet.isEmpty()) {
            hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
            attributeSet2 = new HashPrintServiceAttributeSet();
            objectArray = attributeSet.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] instanceof PrintRequestAttribute) {
                    hashPrintRequestAttributeSet.add((Attribute)objectArray[i]);
                    continue;
                }
                if (!(objectArray[i] instanceof PrintServiceAttribute)) continue;
                attributeSet2.add((Attribute)objectArray[i]);
            }
        }
        objectArray = null;
        objectArray = attributeSet2 != null && attributeSet2.get(PrinterName.class) != null ? ((printService = this.getPrintServiceByName((printerName = (PrinterName)attributeSet2.get(PrinterName.class)).getValue())) == null || !this.matchingService(printService, (PrintServiceAttributeSet)attributeSet2) ? new PrintService[]{} : new PrintService[]{printService}) : this.getPrintServices();
        if (objectArray.length == 0) {
            return objectArray;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            try {
                if (objectArray[i].getUnsupportedAttributes(docFlavor, hashPrintRequestAttributeSet) != null) continue;
                arrayList.add(objectArray[i]);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        objectArray = new PrintService[arrayList.size()];
        return (PrintService[])arrayList.toArray(objectArray);
    }

    @Override
    public MultiDocPrintService[] getMultiDocPrintServices(DocFlavor[] docFlavorArray, AttributeSet attributeSet) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        return new MultiDocPrintService[0];
    }

    @Override
    public synchronized PrintService getDefaultPrintService() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        this.defaultPrinter = this.getDefaultPrinterName();
        if (this.defaultPrinter == null) {
            return null;
        }
        if (this.defaultPrintService != null && this.defaultPrintService.getName().equals(this.defaultPrinter)) {
            return this.defaultPrintService;
        }
        this.defaultPrintService = null;
        if (this.printServices != null) {
            for (int i = 0; i < this.printServices.length; ++i) {
                if (!this.defaultPrinter.equals(this.printServices[i].getName())) continue;
                this.defaultPrintService = this.printServices[i];
                break;
            }
        }
        if (this.defaultPrintService == null) {
            this.defaultPrintService = new Win32PrintService(this.defaultPrinter);
        }
        return this.defaultPrintService;
    }

    private native String getDefaultPrinterName();

    private native String[] getAllPrinterNames();

    private native long notifyFirstPrinterChange(String var1);

    private native void notifyClosePrinterChange(long var1);

    private native int notifyPrinterChange(long var1);

    private native String[] getRemotePrintersNames();

    static {
        String string;
        pollServices = true;
        minRefreshTime = 240;
        String string2 = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.print.polling"));
        if (string2 != null && string2.equalsIgnoreCase("false")) {
            pollServices = false;
        }
        if ((string = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.print.minRefreshTime"))) != null) {
            try {
                minRefreshTime = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (minRefreshTime < 240) {
                minRefreshTime = 240;
            }
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("awt");
                return null;
            }
        });
    }

    class RemotePrinterChangeListener
    extends Thread {
        private String[] prevRemotePrinters;

        RemotePrinterChangeListener() {
            this.prevRemotePrinters = PrintServiceLookupProvider.this.getRemotePrintersNames();
        }

        private boolean doCompare(String[] stringArray, String[] stringArray2) {
            if (stringArray == null && stringArray2 == null) {
                return false;
            }
            if (stringArray == null || stringArray2 == null) {
                return true;
            }
            if (stringArray.length != stringArray2.length) {
                return true;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                for (int j = 0; j < stringArray2.length; ++j) {
                    if (stringArray[i] == null && stringArray2[j] == null) continue;
                    if (stringArray[i] == null || stringArray2[j] == null) {
                        return true;
                    }
                    if (stringArray[i].equals(stringArray2[j])) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public void run() {
            this.prevRemotePrinters = PrintServiceLookupProvider.this.getRemotePrintersNames();
            while (true) {
                try {
                    Thread.sleep(minRefreshTime * 1000);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                String[] stringArray = PrintServiceLookupProvider.this.getRemotePrintersNames();
                if (!this.doCompare(this.prevRemotePrinters, stringArray)) continue;
                PrintServiceLookupProvider.this.refreshServices();
                this.prevRemotePrinters = stringArray;
            }
        }
    }

    class PrinterChangeListener
    extends Thread {
        long chgObj;

        PrinterChangeListener() {
            this.chgObj = PrintServiceLookupProvider.this.notifyFirstPrinterChange(null);
        }

        @Override
        public void run() {
            block3: {
                if (this.chgObj == -1L) break block3;
                while (PrintServiceLookupProvider.this.notifyPrinterChange(this.chgObj) != 0) {
                    try {
                        PrintServiceLookupProvider.this.refreshServices();
                    }
                    catch (SecurityException securityException) {
                        break block3;
                    }
                }
                PrintServiceLookupProvider.this.notifyClosePrinterChange(this.chgObj);
            }
        }
    }
}

