/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.example;

import com.jediterm.app.PlatformUtilKt;
import com.jediterm.pty.PtyProcessTtyConnector;
import com.jediterm.terminal.CursorShape;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.ui.JediTermWidget;
import com.jediterm.terminal.ui.settings.DefaultSettingsProvider;
import com.pty4j.PtyProcess;
import com.pty4j.PtyProcessBuilder;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class BasicTerminalShellExample {
    @NotNull
    private static JediTermWidget createTerminalWidget() {
        JediTermWidget widget = new JediTermWidget(80, 24, new DefaultSettingsProvider());
        widget.getTerminalPanel().setDefaultCursorShape(CursorShape.BLINK_UNDERLINE);
        widget.setTtyConnector(BasicTerminalShellExample.createTtyConnector());
        widget.start();
        return widget;
    }

    @NotNull
    private static TtyConnector createTtyConnector() {
        try {
            String[] command;
            Map<String, String> envs = System.getenv();
            if (PlatformUtilKt.isWindows()) {
                command = new String[]{"cmd.exe"};
            } else {
                command = new String[]{"/bin/bash", "--login"};
                envs = new HashMap<String, String>(System.getenv());
                envs.put("TERM", "xterm-256color");
            }
            PtyProcess process = new PtyProcessBuilder().setCommand(command).setEnvironment(envs).start();
            return new PtyProcessTtyConnector(process, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static void createAndShowGUI() {
        final JFrame frame = new JFrame("Basic Terminal Shell Example");
        frame.setDefaultCloseOperation(2);
        final JediTermWidget widget = BasicTerminalShellExample.createTerminalWidget();
        widget.addListener(terminalWidget -> {
            widget.close();
            SwingUtilities.invokeLater(() -> {
                if (frame.isVisible()) {
                    frame.dispose();
                }
            });
        });
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                frame.setVisible(false);
                widget.getTtyConnector().close();
            }
        });
        frame.setContentPane(widget);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(BasicTerminalShellExample::createAndShowGUI);
    }
}

