/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal.ui;

import com.jediterm.terminal.ui.TerminalActionMenuBuilder;
import com.jediterm.terminal.ui.TerminalActionPresentation;
import com.jediterm.terminal.ui.TerminalActionProvider;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TerminalAction {
    private final TerminalActionPresentation myPresentation;
    private final Predicate<KeyEvent> myRunnable;
    private Supplier<Boolean> myEnabledSupplier = () -> true;
    private Integer myMnemonicKeyCode = null;
    private boolean mySeparatorBefore = false;
    private boolean myHidden = false;

    public TerminalAction(@NotNull TerminalActionPresentation presentation, @NotNull Predicate<KeyEvent> runnable) {
        this.myPresentation = presentation;
        this.myRunnable = runnable;
    }

    public TerminalAction(@NotNull TerminalActionPresentation presentation) {
        this(presentation, keyEvent -> true);
    }

    @NotNull
    public TerminalActionPresentation getPresentation() {
        return this.myPresentation;
    }

    @Nullable
    public Integer getMnemonicKeyCode() {
        return this.myMnemonicKeyCode;
    }

    public boolean matches(KeyEvent e) {
        for (KeyStroke ks : this.myPresentation.getKeyStrokes()) {
            if (!ks.equals(KeyStroke.getKeyStrokeForEvent(e))) continue;
            return true;
        }
        return false;
    }

    public boolean isEnabled(@Nullable KeyEvent e) {
        return this.myEnabledSupplier.get();
    }

    public boolean actionPerformed(@Nullable KeyEvent e) {
        return this.myRunnable.test(e);
    }

    public static boolean processEvent(@NotNull TerminalActionProvider actionProvider, @NotNull KeyEvent e) {
        for (TerminalAction a : actionProvider.getActions()) {
            if (!a.matches(e)) continue;
            return a.isEnabled(e) && a.actionPerformed(e);
        }
        if (actionProvider.getNextProvider() != null) {
            return TerminalAction.processEvent(actionProvider.getNextProvider(), e);
        }
        return false;
    }

    @NotNull
    public String getName() {
        return this.myPresentation.getName();
    }

    public TerminalAction withMnemonicKey(Integer key) {
        this.myMnemonicKeyCode = key;
        return this;
    }

    public TerminalAction withEnabledSupplier(@NotNull Supplier<Boolean> enabledSupplier) {
        this.myEnabledSupplier = enabledSupplier;
        return this;
    }

    public TerminalAction separatorBefore(boolean enabled) {
        this.mySeparatorBefore = enabled;
        return this;
    }

    @NotNull
    private JMenuItem toMenuItem() {
        JMenuItem menuItem = new JMenuItem(this.myPresentation.getName());
        if (this.myMnemonicKeyCode != null) {
            menuItem.setMnemonic(this.myMnemonicKeyCode);
        }
        if (!this.myPresentation.getKeyStrokes().isEmpty()) {
            menuItem.setAccelerator(this.myPresentation.getKeyStrokes().get(0));
        }
        menuItem.addActionListener(actionEvent -> this.actionPerformed(null));
        menuItem.setEnabled(this.isEnabled(null));
        return menuItem;
    }

    public boolean isSeparated() {
        return this.mySeparatorBefore;
    }

    public boolean isHidden() {
        return this.myHidden;
    }

    public TerminalAction withHidden(boolean hidden) {
        this.myHidden = hidden;
        return this;
    }

    public String toString() {
        return "'" + this.myPresentation.getName() + "'";
    }

    public static void fillMenu(final @NotNull JPopupMenu menu, @NotNull TerminalActionProvider actionProvider) {
        TerminalAction.buildMenu(actionProvider, new TerminalActionMenuBuilder(){

            @Override
            public void addAction(@NotNull TerminalAction action) {
                menu.add(action.toMenuItem());
            }

            @Override
            public void addSeparator() {
                menu.addSeparator();
            }
        });
    }

    public static void buildMenu(@NotNull TerminalActionProvider provider, @NotNull TerminalActionMenuBuilder builder) {
        List<TerminalActionProvider> actionProviders = TerminalAction.listActionProviders(provider);
        boolean emptyGroup = true;
        for (TerminalActionProvider actionProvider : actionProviders) {
            boolean addSeparator = !emptyGroup;
            emptyGroup = true;
            for (TerminalAction action : actionProvider.getActions()) {
                if (action.isHidden()) continue;
                if (addSeparator || action.isSeparated()) {
                    builder.addSeparator();
                    addSeparator = false;
                }
                builder.addAction(action);
                emptyGroup = false;
            }
        }
    }

    @NotNull
    private static List<TerminalActionProvider> listActionProviders(@NotNull TerminalActionProvider provider) {
        ArrayList<TerminalActionProvider> providers = new ArrayList<TerminalActionProvider>();
        for (TerminalActionProvider p = provider; p != null; p = p.getNextProvider()) {
            providers.add(0, p);
        }
        return providers;
    }
}

