/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.ui.debug;

import com.jediterm.terminal.LoggingTtyConnector;
import com.jediterm.terminal.model.LinesStorageKt;
import com.jediterm.terminal.ui.TerminalSession;
import com.jediterm.ui.debug.TerminalDebugUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public enum DebugBufferType {
    Screen{

        @Override
        @NotNull
        public String getValue(TerminalSession session, int stateIndex) {
            List<LoggingTtyConnector.TerminalState> states = ((LoggingTtyConnector)((Object)session.getTtyConnector())).getStates();
            if (stateIndex == states.size()) {
                return session.getTerminalTextBuffer().getScreenLines();
            }
            return states.get((int)stateIndex).myScreenLines;
        }
    }
    ,
    BackStyle{

        @Override
        @NotNull
        public String getValue(TerminalSession session, int stateIndex) {
            List<LoggingTtyConnector.TerminalState> states = ((LoggingTtyConnector)((Object)session.getTtyConnector())).getStates();
            if (stateIndex == states.size()) {
                return TerminalDebugUtil.getStyleLines(session.getTerminalTextBuffer());
            }
            return states.get((int)stateIndex).myStyleLines;
        }
    }
    ,
    History{

        @Override
        @NotNull
        public String getValue(TerminalSession session, int stateIndex) {
            List<LoggingTtyConnector.TerminalState> states = ((LoggingTtyConnector)((Object)session.getTtyConnector())).getStates();
            if (stateIndex == states.size()) {
                return LinesStorageKt.getLinesAsString(session.getTerminalTextBuffer().getHistoryLinesStorage());
            }
            return states.get((int)stateIndex).myHistoryLines;
        }
    };


    @NotNull
    public abstract String getValue(TerminalSession var1, int var2);
}

